package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "recommendedActions", 
    "resolvedTargetsCount", 
    "simulationEventsContent", 
    "trainingEventsContent"})
@JsonInclude(Include.NON_NULL)
public class SimulationReportOverview implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("recommendedActions")
    protected List<RecommendedAction> recommendedActions;

    @JsonProperty("recommendedActions@nextLink")
    protected String recommendedActionsNextLink;

    @JsonProperty("resolvedTargetsCount")
    protected Integer resolvedTargetsCount;

    @JsonProperty("simulationEventsContent")
    protected SimulationEventsContent simulationEventsContent;

    @JsonProperty("trainingEventsContent")
    protected TrainingEventsContent trainingEventsContent;

    protected SimulationReportOverview() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationReportOverview";
    }

    @Property(name="recommendedActions")
    @JsonIgnore
    public CollectionPage<RecommendedAction> getRecommendedActions() {
        return new CollectionPage<RecommendedAction>(contextPath, RecommendedAction.class, this.recommendedActions, Optional.ofNullable(recommendedActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recommendedActions")
    @JsonIgnore
    public CollectionPage<RecommendedAction> getRecommendedActions(HttpRequestOptions options) {
        return new CollectionPage<RecommendedAction>(contextPath, RecommendedAction.class, this.recommendedActions, Optional.ofNullable(recommendedActionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="resolvedTargetsCount")
    @JsonIgnore
    public Optional<Integer> getResolvedTargetsCount() {
        return Optional.ofNullable(resolvedTargetsCount);
    }

    public SimulationReportOverview withResolvedTargetsCount(Integer resolvedTargetsCount) {
        SimulationReportOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationReportOverview");
        _x.resolvedTargetsCount = resolvedTargetsCount;
        return _x;
    }

    @Property(name="simulationEventsContent")
    @JsonIgnore
    public Optional<SimulationEventsContent> getSimulationEventsContent() {
        return Optional.ofNullable(simulationEventsContent);
    }

    public SimulationReportOverview withSimulationEventsContent(SimulationEventsContent simulationEventsContent) {
        SimulationReportOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationReportOverview");
        _x.simulationEventsContent = simulationEventsContent;
        return _x;
    }

    @Property(name="trainingEventsContent")
    @JsonIgnore
    public Optional<TrainingEventsContent> getTrainingEventsContent() {
        return Optional.ofNullable(trainingEventsContent);
    }

    public SimulationReportOverview withTrainingEventsContent(TrainingEventsContent trainingEventsContent) {
        SimulationReportOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationReportOverview");
        _x.trainingEventsContent = trainingEventsContent;
        return _x;
    }

    public SimulationReportOverview withUnmappedField(String name, Object value) {
        SimulationReportOverview _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RecommendedAction> recommendedActions;
        private String recommendedActionsNextLink;
        private Integer resolvedTargetsCount;
        private SimulationEventsContent simulationEventsContent;
        private TrainingEventsContent trainingEventsContent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder recommendedActions(List<RecommendedAction> recommendedActions) {
            this.recommendedActions = recommendedActions;
            this.changedFields = changedFields.add("recommendedActions");
            return this;
        }

        public Builder recommendedActions(RecommendedAction... recommendedActions) {
            return recommendedActions(Arrays.asList(recommendedActions));
        }

        public Builder recommendedActionsNextLink(String recommendedActionsNextLink) {
            this.recommendedActionsNextLink = recommendedActionsNextLink;
            this.changedFields = changedFields.add("recommendedActions");
            return this;
        }

        public Builder resolvedTargetsCount(Integer resolvedTargetsCount) {
            this.resolvedTargetsCount = resolvedTargetsCount;
            this.changedFields = changedFields.add("resolvedTargetsCount");
            return this;
        }

        public Builder simulationEventsContent(SimulationEventsContent simulationEventsContent) {
            this.simulationEventsContent = simulationEventsContent;
            this.changedFields = changedFields.add("simulationEventsContent");
            return this;
        }

        public Builder trainingEventsContent(TrainingEventsContent trainingEventsContent) {
            this.trainingEventsContent = trainingEventsContent;
            this.changedFields = changedFields.add("trainingEventsContent");
            return this;
        }

        public SimulationReportOverview build() {
            SimulationReportOverview _x = new SimulationReportOverview();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationReportOverview";
            _x.recommendedActions = recommendedActions;
            _x.recommendedActionsNextLink = recommendedActionsNextLink;
            _x.resolvedTargetsCount = resolvedTargetsCount;
            _x.simulationEventsContent = simulationEventsContent;
            _x.trainingEventsContent = trainingEventsContent;
            return _x;
        }
    }

    private SimulationReportOverview _copy() {
        SimulationReportOverview _x = new SimulationReportOverview();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.recommendedActions = recommendedActions;
        _x.resolvedTargetsCount = resolvedTargetsCount;
        _x.simulationEventsContent = simulationEventsContent;
        _x.trainingEventsContent = trainingEventsContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationReportOverview[");
        b.append("recommendedActions=");
        b.append(this.recommendedActions);
        b.append(", ");
        b.append("resolvedTargetsCount=");
        b.append(this.resolvedTargetsCount);
        b.append(", ");
        b.append("simulationEventsContent=");
        b.append(this.simulationEventsContent);
        b.append(", ");
        b.append("trainingEventsContent=");
        b.append(this.trainingEventsContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
