package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificateUpdateResult", 
    "lastRunDateTime"})
@JsonInclude(Include.NON_NULL)
public class SigningCertificateUpdateStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certificateUpdateResult")
    protected String certificateUpdateResult;

    @JsonProperty("lastRunDateTime")
    protected OffsetDateTime lastRunDateTime;

    protected SigningCertificateUpdateStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signingCertificateUpdateStatus";
    }

    @Property(name="certificateUpdateResult")
    @JsonIgnore
    public Optional<String> getCertificateUpdateResult() {
        return Optional.ofNullable(certificateUpdateResult);
    }

    public SigningCertificateUpdateStatus withCertificateUpdateResult(String certificateUpdateResult) {
        SigningCertificateUpdateStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signingCertificateUpdateStatus");
        _x.certificateUpdateResult = certificateUpdateResult;
        return _x;
    }

    @Property(name="lastRunDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRunDateTime() {
        return Optional.ofNullable(lastRunDateTime);
    }

    public SigningCertificateUpdateStatus withLastRunDateTime(OffsetDateTime lastRunDateTime) {
        SigningCertificateUpdateStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signingCertificateUpdateStatus");
        _x.lastRunDateTime = lastRunDateTime;
        return _x;
    }

    public SigningCertificateUpdateStatus withUnmappedField(String name, Object value) {
        SigningCertificateUpdateStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String certificateUpdateResult;
        private OffsetDateTime lastRunDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder certificateUpdateResult(String certificateUpdateResult) {
            this.certificateUpdateResult = certificateUpdateResult;
            this.changedFields = changedFields.add("certificateUpdateResult");
            return this;
        }

        public Builder lastRunDateTime(OffsetDateTime lastRunDateTime) {
            this.lastRunDateTime = lastRunDateTime;
            this.changedFields = changedFields.add("lastRunDateTime");
            return this;
        }

        public SigningCertificateUpdateStatus build() {
            SigningCertificateUpdateStatus _x = new SigningCertificateUpdateStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.signingCertificateUpdateStatus";
            _x.certificateUpdateResult = certificateUpdateResult;
            _x.lastRunDateTime = lastRunDateTime;
            return _x;
        }
    }

    private SigningCertificateUpdateStatus _copy() {
        SigningCertificateUpdateStatus _x = new SigningCertificateUpdateStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certificateUpdateResult = certificateUpdateResult;
        _x.lastRunDateTime = lastRunDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SigningCertificateUpdateStatus[");
        b.append("certificateUpdateResult=");
        b.append(this.certificateUpdateResult);
        b.append(", ");
        b.append("lastRunDateTime=");
        b.append(this.lastRunDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
