package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "email", 
    "invitedBy", 
    "redeemedBy", 
    "signInRequired"})
@JsonInclude(Include.NON_NULL)
public class SharingInvitation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("invitedBy")
    protected IdentitySet invitedBy;

    @JsonProperty("redeemedBy")
    protected String redeemedBy;

    @JsonProperty("signInRequired")
    protected Boolean signInRequired;

    protected SharingInvitation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharingInvitation";
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public SharingInvitation withEmail(String email) {
        SharingInvitation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingInvitation");
        _x.email = email;
        return _x;
    }

    @Property(name="invitedBy")
    @JsonIgnore
    public Optional<IdentitySet> getInvitedBy() {
        return Optional.ofNullable(invitedBy);
    }

    public SharingInvitation withInvitedBy(IdentitySet invitedBy) {
        SharingInvitation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingInvitation");
        _x.invitedBy = invitedBy;
        return _x;
    }

    @Property(name="redeemedBy")
    @JsonIgnore
    public Optional<String> getRedeemedBy() {
        return Optional.ofNullable(redeemedBy);
    }

    public SharingInvitation withRedeemedBy(String redeemedBy) {
        SharingInvitation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingInvitation");
        _x.redeemedBy = redeemedBy;
        return _x;
    }

    @Property(name="signInRequired")
    @JsonIgnore
    public Optional<Boolean> getSignInRequired() {
        return Optional.ofNullable(signInRequired);
    }

    public SharingInvitation withSignInRequired(Boolean signInRequired) {
        SharingInvitation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingInvitation");
        _x.signInRequired = signInRequired;
        return _x;
    }

    public SharingInvitation withUnmappedField(String name, Object value) {
        SharingInvitation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String email;
        private IdentitySet invitedBy;
        private String redeemedBy;
        private Boolean signInRequired;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder invitedBy(IdentitySet invitedBy) {
            this.invitedBy = invitedBy;
            this.changedFields = changedFields.add("invitedBy");
            return this;
        }

        public Builder redeemedBy(String redeemedBy) {
            this.redeemedBy = redeemedBy;
            this.changedFields = changedFields.add("redeemedBy");
            return this;
        }

        public Builder signInRequired(Boolean signInRequired) {
            this.signInRequired = signInRequired;
            this.changedFields = changedFields.add("signInRequired");
            return this;
        }

        public SharingInvitation build() {
            SharingInvitation _x = new SharingInvitation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharingInvitation";
            _x.email = email;
            _x.invitedBy = invitedBy;
            _x.redeemedBy = redeemedBy;
            _x.signInRequired = signInRequired;
            return _x;
        }
    }

    private SharingInvitation _copy() {
        SharingInvitation _x = new SharingInvitation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.email = email;
        _x.invitedBy = invitedBy;
        _x.redeemedBy = redeemedBy;
        _x.signInRequired = signInRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharingInvitation[");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("invitedBy=");
        b.append(this.invitedBy);
        b.append(", ");
        b.append("redeemedBy=");
        b.append(this.redeemedBy);
        b.append(", ");
        b.append("signInRequired=");
        b.append(this.signInRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
