package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sharedBy", 
    "sharedDateTime", 
    "sharingReference", 
    "sharingSubject", 
    "sharingType"})
@JsonInclude(Include.NON_NULL)
public class SharingDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sharedBy")
    protected InsightIdentity sharedBy;

    @JsonProperty("sharedDateTime")
    protected OffsetDateTime sharedDateTime;

    @JsonProperty("sharingReference")
    protected ResourceReference sharingReference;

    @JsonProperty("sharingSubject")
    protected String sharingSubject;

    @JsonProperty("sharingType")
    protected String sharingType;

    protected SharingDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharingDetail";
    }

    @Property(name="sharedBy")
    @JsonIgnore
    public Optional<InsightIdentity> getSharedBy() {
        return Optional.ofNullable(sharedBy);
    }

    public SharingDetail withSharedBy(InsightIdentity sharedBy) {
        SharingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingDetail");
        _x.sharedBy = sharedBy;
        return _x;
    }

    @Property(name="sharedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSharedDateTime() {
        return Optional.ofNullable(sharedDateTime);
    }

    public SharingDetail withSharedDateTime(OffsetDateTime sharedDateTime) {
        SharingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingDetail");
        _x.sharedDateTime = sharedDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property sharingReference
     */
    @Property(name="sharingReference")
    @JsonIgnore
    public Optional<ResourceReference> getSharingReference() {
        return Optional.ofNullable(sharingReference);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sharingReference}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param sharingReference
     *            new value of {@code sharingReference} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharingReference} field changed
     */
    public SharingDetail withSharingReference(ResourceReference sharingReference) {
        SharingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingDetail");
        _x.sharingReference = sharingReference;
        return _x;
    }

    @Property(name="sharingSubject")
    @JsonIgnore
    public Optional<String> getSharingSubject() {
        return Optional.ofNullable(sharingSubject);
    }

    public SharingDetail withSharingSubject(String sharingSubject) {
        SharingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingDetail");
        _x.sharingSubject = sharingSubject;
        return _x;
    }

    @Property(name="sharingType")
    @JsonIgnore
    public Optional<String> getSharingType() {
        return Optional.ofNullable(sharingType);
    }

    public SharingDetail withSharingType(String sharingType) {
        SharingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingDetail");
        _x.sharingType = sharingType;
        return _x;
    }

    public SharingDetail withUnmappedField(String name, Object value) {
        SharingDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private InsightIdentity sharedBy;
        private OffsetDateTime sharedDateTime;
        private ResourceReference sharingReference;
        private String sharingSubject;
        private String sharingType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder sharedBy(InsightIdentity sharedBy) {
            this.sharedBy = sharedBy;
            this.changedFields = changedFields.add("sharedBy");
            return this;
        }

        public Builder sharedDateTime(OffsetDateTime sharedDateTime) {
            this.sharedDateTime = sharedDateTime;
            this.changedFields = changedFields.add("sharedDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param sharingReference
         *            value of {@code sharingReference} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharingReference(ResourceReference sharingReference) {
            this.sharingReference = sharingReference;
            this.changedFields = changedFields.add("sharingReference");
            return this;
        }

        public Builder sharingSubject(String sharingSubject) {
            this.sharingSubject = sharingSubject;
            this.changedFields = changedFields.add("sharingSubject");
            return this;
        }

        public Builder sharingType(String sharingType) {
            this.sharingType = sharingType;
            this.changedFields = changedFields.add("sharingType");
            return this;
        }

        public SharingDetail build() {
            SharingDetail _x = new SharingDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharingDetail";
            _x.sharedBy = sharedBy;
            _x.sharedDateTime = sharedDateTime;
            _x.sharingReference = sharingReference;
            _x.sharingSubject = sharingSubject;
            _x.sharingType = sharingType;
            return _x;
        }
    }

    private SharingDetail _copy() {
        SharingDetail _x = new SharingDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.sharedBy = sharedBy;
        _x.sharedDateTime = sharedDateTime;
        _x.sharingReference = sharingReference;
        _x.sharingSubject = sharingSubject;
        _x.sharingType = sharingType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharingDetail[");
        b.append("sharedBy=");
        b.append(this.sharedBy);
        b.append(", ");
        b.append("sharedDateTime=");
        b.append(this.sharedDateTime);
        b.append(", ");
        b.append("sharingReference=");
        b.append(this.sharingReference);
        b.append(", ");
        b.append("sharingSubject=");
        b.append(this.sharingSubject);
        b.append(", ");
        b.append("sharingType=");
        b.append(this.sharingType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
