package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dataQuota", 
    "dataToSync", 
    "dataUsed", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class SharedAppleDeviceUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dataQuota")
    protected Long dataQuota;

    @JsonProperty("dataToSync")
    protected Boolean dataToSync;

    @JsonProperty("dataUsed")
    protected Long dataUsed;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected SharedAppleDeviceUser() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharedAppleDeviceUser";
    }

    /**
     * <i>“Data quota”</i>
     * 
     * @return property dataQuota
     */
    @Property(name="dataQuota")
    @JsonIgnore
    public Optional<Long> getDataQuota() {
        return Optional.ofNullable(dataQuota);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataQuota} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Data quota”</i>
     * 
     * @param dataQuota
     *            new value of {@code dataQuota} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataQuota} field changed
     */
    public SharedAppleDeviceUser withDataQuota(Long dataQuota) {
        SharedAppleDeviceUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedAppleDeviceUser");
        _x.dataQuota = dataQuota;
        return _x;
    }

    /**
     * <i>“Data to sync”</i>
     * 
     * @return property dataToSync
     */
    @Property(name="dataToSync")
    @JsonIgnore
    public Optional<Boolean> getDataToSync() {
        return Optional.ofNullable(dataToSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataToSync} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Data to sync”</i>
     * 
     * @param dataToSync
     *            new value of {@code dataToSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataToSync} field changed
     */
    public SharedAppleDeviceUser withDataToSync(Boolean dataToSync) {
        SharedAppleDeviceUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedAppleDeviceUser");
        _x.dataToSync = dataToSync;
        return _x;
    }

    /**
     * <i>“Data quota”</i>
     * 
     * @return property dataUsed
     */
    @Property(name="dataUsed")
    @JsonIgnore
    public Optional<Long> getDataUsed() {
        return Optional.ofNullable(dataUsed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataUsed} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Data quota”</i>
     * 
     * @param dataUsed
     *            new value of {@code dataUsed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataUsed} field changed
     */
    public SharedAppleDeviceUser withDataUsed(Long dataUsed) {
        SharedAppleDeviceUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedAppleDeviceUser");
        _x.dataUsed = dataUsed;
        return _x;
    }

    /**
     * <i>“User name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public SharedAppleDeviceUser withUserPrincipalName(String userPrincipalName) {
        SharedAppleDeviceUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedAppleDeviceUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public SharedAppleDeviceUser withUnmappedField(String name, Object value) {
        SharedAppleDeviceUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long dataQuota;
        private Boolean dataToSync;
        private Long dataUsed;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Data quota”</i>
         * 
         * @param dataQuota
         *            value of {@code dataQuota} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataQuota(Long dataQuota) {
            this.dataQuota = dataQuota;
            this.changedFields = changedFields.add("dataQuota");
            return this;
        }

        /**
         * <i>“Data to sync”</i>
         * 
         * @param dataToSync
         *            value of {@code dataToSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataToSync(Boolean dataToSync) {
            this.dataToSync = dataToSync;
            this.changedFields = changedFields.add("dataToSync");
            return this;
        }

        /**
         * <i>“Data quota”</i>
         * 
         * @param dataUsed
         *            value of {@code dataUsed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataUsed(Long dataUsed) {
            this.dataUsed = dataUsed;
            this.changedFields = changedFields.add("dataUsed");
            return this;
        }

        /**
         * <i>“User name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public SharedAppleDeviceUser build() {
            SharedAppleDeviceUser _x = new SharedAppleDeviceUser();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharedAppleDeviceUser";
            _x.dataQuota = dataQuota;
            _x.dataToSync = dataToSync;
            _x.dataUsed = dataUsed;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private SharedAppleDeviceUser _copy() {
        SharedAppleDeviceUser _x = new SharedAppleDeviceUser();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dataQuota = dataQuota;
        _x.dataToSync = dataToSync;
        _x.dataUsed = dataUsed;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharedAppleDeviceUser[");
        b.append("dataQuota=");
        b.append(this.dataQuota);
        b.append(", ");
        b.append("dataToSync=");
        b.append(this.dataToSync);
        b.append(", ");
        b.append("dataUsed=");
        b.append(this.dataUsed);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
