package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "hasGraphMailbox", 
    "hasLicense", 
    "hasOptedOut"})
@JsonInclude(Include.NON_NULL)
public class Settings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hasGraphMailbox")
    protected Boolean hasGraphMailbox;

    @JsonProperty("hasLicense")
    protected Boolean hasLicense;

    @JsonProperty("hasOptedOut")
    protected Boolean hasOptedOut;

    protected Settings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.settings";
    }

    @Property(name="hasGraphMailbox")
    @JsonIgnore
    public Optional<Boolean> getHasGraphMailbox() {
        return Optional.ofNullable(hasGraphMailbox);
    }

    public Settings withHasGraphMailbox(Boolean hasGraphMailbox) {
        Settings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settings");
        _x.hasGraphMailbox = hasGraphMailbox;
        return _x;
    }

    @Property(name="hasLicense")
    @JsonIgnore
    public Optional<Boolean> getHasLicense() {
        return Optional.ofNullable(hasLicense);
    }

    public Settings withHasLicense(Boolean hasLicense) {
        Settings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settings");
        _x.hasLicense = hasLicense;
        return _x;
    }

    @Property(name="hasOptedOut")
    @JsonIgnore
    public Optional<Boolean> getHasOptedOut() {
        return Optional.ofNullable(hasOptedOut);
    }

    public Settings withHasOptedOut(Boolean hasOptedOut) {
        Settings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settings");
        _x.hasOptedOut = hasOptedOut;
        return _x;
    }

    public Settings withUnmappedField(String name, Object value) {
        Settings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean hasGraphMailbox;
        private Boolean hasLicense;
        private Boolean hasOptedOut;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hasGraphMailbox(Boolean hasGraphMailbox) {
            this.hasGraphMailbox = hasGraphMailbox;
            this.changedFields = changedFields.add("hasGraphMailbox");
            return this;
        }

        public Builder hasLicense(Boolean hasLicense) {
            this.hasLicense = hasLicense;
            this.changedFields = changedFields.add("hasLicense");
            return this;
        }

        public Builder hasOptedOut(Boolean hasOptedOut) {
            this.hasOptedOut = hasOptedOut;
            this.changedFields = changedFields.add("hasOptedOut");
            return this;
        }

        public Settings build() {
            Settings _x = new Settings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.settings";
            _x.hasGraphMailbox = hasGraphMailbox;
            _x.hasLicense = hasLicense;
            _x.hasOptedOut = hasOptedOut;
            return _x;
        }
    }

    private Settings _copy() {
        Settings _x = new Settings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hasGraphMailbox = hasGraphMailbox;
        _x.hasLicense = hasLicense;
        _x.hasOptedOut = hasOptedOut;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Settings[");
        b.append("hasGraphMailbox=");
        b.append(this.hasGraphMailbox);
        b.append(", ");
        b.append("hasLicense=");
        b.append(this.hasLicense);
        b.append(", ");
        b.append("hasOptedOut=");
        b.append(this.hasOptedOut);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
