package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PostType;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "postType"})
@JsonInclude(Include.NON_NULL)
public class ServiceHealthIssuePost implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected ItemBody description;

    @JsonProperty("postType")
    protected PostType postType;

    protected ServiceHealthIssuePost() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceHealthIssuePost";
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ServiceHealthIssuePost withCreatedDateTime(OffsetDateTime createdDateTime) {
        ServiceHealthIssuePost _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssuePost");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<ItemBody> getDescription() {
        return Optional.ofNullable(description);
    }

    public ServiceHealthIssuePost withDescription(ItemBody description) {
        ServiceHealthIssuePost _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssuePost");
        _x.description = description;
        return _x;
    }

    @Property(name="postType")
    @JsonIgnore
    public Optional<PostType> getPostType() {
        return Optional.ofNullable(postType);
    }

    public ServiceHealthIssuePost withPostType(PostType postType) {
        ServiceHealthIssuePost _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceHealthIssuePost");
        _x.postType = postType;
        return _x;
    }

    public ServiceHealthIssuePost withUnmappedField(String name, Object value) {
        ServiceHealthIssuePost _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdDateTime;
        private ItemBody description;
        private PostType postType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(ItemBody description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder postType(PostType postType) {
            this.postType = postType;
            this.changedFields = changedFields.add("postType");
            return this;
        }

        public ServiceHealthIssuePost build() {
            ServiceHealthIssuePost _x = new ServiceHealthIssuePost();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceHealthIssuePost";
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.postType = postType;
            return _x;
        }
    }

    private ServiceHealthIssuePost _copy() {
        ServiceHealthIssuePost _x = new ServiceHealthIssuePost();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.postType = postType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceHealthIssuePost[");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("postType=");
        b.append(this.postType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
