package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "customKeyIdentifier", 
    "displayName", 
    "endDateTime", 
    "key", 
    "keyId", 
    "startDateTime", 
    "thumbprint", 
    "type", 
    "usage"})
@JsonInclude(Include.NON_NULL)
public class SelfSignedCertificate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("customKeyIdentifier")
    protected byte[] customKeyIdentifier;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("key")
    protected byte[] key;

    @JsonProperty("keyId")
    protected UUID keyId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("thumbprint")
    protected String thumbprint;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("usage")
    protected String usage;

    protected SelfSignedCertificate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.selfSignedCertificate";
    }

    @Property(name="customKeyIdentifier")
    @JsonIgnore
    public Optional<byte[]> getCustomKeyIdentifier() {
        return Optional.ofNullable(customKeyIdentifier);
    }

    public SelfSignedCertificate withCustomKeyIdentifier(byte[] customKeyIdentifier) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.customKeyIdentifier = customKeyIdentifier;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SelfSignedCertificate withDisplayName(String displayName) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public SelfSignedCertificate withEndDateTime(OffsetDateTime endDateTime) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<byte[]> getKey() {
        return Optional.ofNullable(key);
    }

    public SelfSignedCertificate withKey(byte[] key) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.key = key;
        return _x;
    }

    @Property(name="keyId")
    @JsonIgnore
    public Optional<UUID> getKeyId() {
        return Optional.ofNullable(keyId);
    }

    public SelfSignedCertificate withKeyId(UUID keyId) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.keyId = keyId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public SelfSignedCertificate withStartDateTime(OffsetDateTime startDateTime) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="thumbprint")
    @JsonIgnore
    public Optional<String> getThumbprint() {
        return Optional.ofNullable(thumbprint);
    }

    public SelfSignedCertificate withThumbprint(String thumbprint) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.thumbprint = thumbprint;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public SelfSignedCertificate withType(String type) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.type = type;
        return _x;
    }

    @Property(name="usage")
    @JsonIgnore
    public Optional<String> getUsage() {
        return Optional.ofNullable(usage);
    }

    public SelfSignedCertificate withUsage(String usage) {
        SelfSignedCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.selfSignedCertificate");
        _x.usage = usage;
        return _x;
    }

    public SelfSignedCertificate withUnmappedField(String name, Object value) {
        SelfSignedCertificate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] customKeyIdentifier;
        private String displayName;
        private OffsetDateTime endDateTime;
        private byte[] key;
        private UUID keyId;
        private OffsetDateTime startDateTime;
        private String thumbprint;
        private String type;
        private String usage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customKeyIdentifier(byte[] customKeyIdentifier) {
            this.customKeyIdentifier = customKeyIdentifier;
            this.changedFields = changedFields.add("customKeyIdentifier");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder key(byte[] key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder keyId(UUID keyId) {
            this.keyId = keyId;
            this.changedFields = changedFields.add("keyId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            this.changedFields = changedFields.add("thumbprint");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            this.changedFields = changedFields.add("usage");
            return this;
        }

        public SelfSignedCertificate build() {
            SelfSignedCertificate _x = new SelfSignedCertificate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.selfSignedCertificate";
            _x.customKeyIdentifier = customKeyIdentifier;
            _x.displayName = displayName;
            _x.endDateTime = endDateTime;
            _x.key = key;
            _x.keyId = keyId;
            _x.startDateTime = startDateTime;
            _x.thumbprint = thumbprint;
            _x.type = type;
            _x.usage = usage;
            return _x;
        }
    }

    private SelfSignedCertificate _copy() {
        SelfSignedCertificate _x = new SelfSignedCertificate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customKeyIdentifier = customKeyIdentifier;
        _x.displayName = displayName;
        _x.endDateTime = endDateTime;
        _x.key = key;
        _x.keyId = keyId;
        _x.startDateTime = startDateTime;
        _x.thumbprint = thumbprint;
        _x.type = type;
        _x.usage = usage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SelfSignedCertificate[");
        b.append("customKeyIdentifier=");
        b.append(this.customKeyIdentifier);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("keyId=");
        b.append(this.keyId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("thumbprint=");
        b.append(this.thumbprint);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("usage=");
        b.append(this.usage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
