package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SecurityResourceType;

@JsonPropertyOrder({
    "@odata.type", 
    "resource", 
    "resourceType"})
@JsonInclude(Include.NON_NULL)
public class SecurityResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("resource")
    protected String resource;

    @JsonProperty("resourceType")
    protected SecurityResourceType resourceType;

    protected SecurityResource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityResource";
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<String> getResource() {
        return Optional.ofNullable(resource);
    }

    public SecurityResource withResource(String resource) {
        SecurityResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityResource");
        _x.resource = resource;
        return _x;
    }

    @Property(name="resourceType")
    @JsonIgnore
    public Optional<SecurityResourceType> getResourceType() {
        return Optional.ofNullable(resourceType);
    }

    public SecurityResource withResourceType(SecurityResourceType resourceType) {
        SecurityResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityResource");
        _x.resourceType = resourceType;
        return _x;
    }

    public SecurityResource withUnmappedField(String name, Object value) {
        SecurityResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resource;
        private SecurityResourceType resourceType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resource(String resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder resourceType(SecurityResourceType resourceType) {
            this.resourceType = resourceType;
            this.changedFields = changedFields.add("resourceType");
            return this;
        }

        public SecurityResource build() {
            SecurityResource _x = new SecurityResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityResource";
            _x.resource = resource;
            _x.resourceType = resourceType;
            return _x;
        }
    }

    private SecurityResource _copy() {
        SecurityResource _x = new SecurityResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resource = resource;
        _x.resourceType = resourceType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityResource[");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("resourceType=");
        b.append(this.resourceType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
