package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enabled", 
    "endpoint", 
    "provider", 
    "region", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class SecurityProviderStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("endpoint")
    protected String endpoint;

    @JsonProperty("provider")
    protected String provider;

    @JsonProperty("region")
    protected String region;

    @JsonProperty("vendor")
    protected String vendor;

    protected SecurityProviderStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityProviderStatus";
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public SecurityProviderStatus withEnabled(Boolean enabled) {
        SecurityProviderStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityProviderStatus");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="endpoint")
    @JsonIgnore
    public Optional<String> getEndpoint() {
        return Optional.ofNullable(endpoint);
    }

    public SecurityProviderStatus withEndpoint(String endpoint) {
        SecurityProviderStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityProviderStatus");
        _x.endpoint = endpoint;
        return _x;
    }

    @Property(name="provider")
    @JsonIgnore
    public Optional<String> getProvider() {
        return Optional.ofNullable(provider);
    }

    public SecurityProviderStatus withProvider(String provider) {
        SecurityProviderStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityProviderStatus");
        _x.provider = provider;
        return _x;
    }

    @Property(name="region")
    @JsonIgnore
    public Optional<String> getRegion() {
        return Optional.ofNullable(region);
    }

    public SecurityProviderStatus withRegion(String region) {
        SecurityProviderStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityProviderStatus");
        _x.region = region;
        return _x;
    }

    @Property(name="vendor")
    @JsonIgnore
    public Optional<String> getVendor() {
        return Optional.ofNullable(vendor);
    }

    public SecurityProviderStatus withVendor(String vendor) {
        SecurityProviderStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityProviderStatus");
        _x.vendor = vendor;
        return _x;
    }

    public SecurityProviderStatus withUnmappedField(String name, Object value) {
        SecurityProviderStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean enabled;
        private String endpoint;
        private String provider;
        private String region;
        private String vendor;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            this.changedFields = changedFields.add("endpoint");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            this.changedFields = changedFields.add("provider");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.changedFields = changedFields.add("region");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public SecurityProviderStatus build() {
            SecurityProviderStatus _x = new SecurityProviderStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityProviderStatus";
            _x.enabled = enabled;
            _x.endpoint = endpoint;
            _x.provider = provider;
            _x.region = region;
            _x.vendor = vendor;
            return _x;
        }
    }

    private SecurityProviderStatus _copy() {
        SecurityProviderStatus _x = new SecurityProviderStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enabled = enabled;
        _x.endpoint = endpoint;
        _x.provider = provider;
        _x.region = region;
        _x.vendor = vendor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityProviderStatus[");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("endpoint=");
        b.append(this.endpoint);
        b.append(", ");
        b.append("provider=");
        b.append(this.provider);
        b.append(", ");
        b.append("region=");
        b.append(this.region);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
