package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SecurityBaselinePolicySourceType;


/**
 * <i>“The security baseline compliance state of a setting for a device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "sourceId", 
    "sourceType"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineContributingPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("sourceType")
    protected SecurityBaselinePolicySourceType sourceType;

    protected SecurityBaselineContributingPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineContributingPolicy";
    }

    /**
     * <i>“Name of the policy”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the policy”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public SecurityBaselineContributingPolicy withDisplayName(String displayName) {
        SecurityBaselineContributingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineContributingPolicy");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Unique identifier of the policy”</i>
     * 
     * @return property sourceId
     */
    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique identifier of the policy”</i>
     * 
     * @param sourceId
     *            new value of {@code sourceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceId} field changed
     */
    public SecurityBaselineContributingPolicy withSourceId(String sourceId) {
        SecurityBaselineContributingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineContributingPolicy");
        _x.sourceId = sourceId;
        return _x;
    }

    /**
     * <i>“Authoring source of the policy”</i>
     * 
     * @return property sourceType
     */
    @Property(name="sourceType")
    @JsonIgnore
    public Optional<SecurityBaselinePolicySourceType> getSourceType() {
        return Optional.ofNullable(sourceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Authoring source of the policy”</i>
     * 
     * @param sourceType
     *            new value of {@code sourceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceType} field changed
     */
    public SecurityBaselineContributingPolicy withSourceType(SecurityBaselinePolicySourceType sourceType) {
        SecurityBaselineContributingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineContributingPolicy");
        _x.sourceType = sourceType;
        return _x;
    }

    public SecurityBaselineContributingPolicy withUnmappedField(String name, Object value) {
        SecurityBaselineContributingPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String sourceId;
        private SecurityBaselinePolicySourceType sourceType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the policy”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Unique identifier of the policy”</i>
         * 
         * @param sourceId
         *            value of {@code sourceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        /**
         * <i>“Authoring source of the policy”</i>
         * 
         * @param sourceType
         *            value of {@code sourceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceType(SecurityBaselinePolicySourceType sourceType) {
            this.sourceType = sourceType;
            this.changedFields = changedFields.add("sourceType");
            return this;
        }

        public SecurityBaselineContributingPolicy build() {
            SecurityBaselineContributingPolicy _x = new SecurityBaselineContributingPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityBaselineContributingPolicy";
            _x.displayName = displayName;
            _x.sourceId = sourceId;
            _x.sourceType = sourceType;
            return _x;
        }
    }

    private SecurityBaselineContributingPolicy _copy() {
        SecurityBaselineContributingPolicy _x = new SecurityBaselineContributingPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.sourceId = sourceId;
        _x.sourceType = sourceType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineContributingPolicy[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("sourceType=");
        b.append(this.sourceType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
