package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EntityType;

@JsonPropertyOrder({
    "@odata.type", 
    "aggregationFilters", 
    "aggregations", 
    "contentSources", 
    "enableTopResults", 
    "entityTypes", 
    "fields", 
    "from", 
    "query", 
    "queryAlterationOptions", 
    "resultTemplateOptions", 
    "size", 
    "sortProperties", 
    "stored_fields", 
    "trimDuplicates"})
@JsonInclude(Include.NON_NULL)
public class SearchRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("aggregationFilters")
    protected List<String> aggregationFilters;

    @JsonProperty("aggregationFilters@nextLink")
    protected String aggregationFiltersNextLink;

    @JsonProperty("aggregations")
    protected List<AggregationOption> aggregations;

    @JsonProperty("aggregations@nextLink")
    protected String aggregationsNextLink;

    @JsonProperty("contentSources")
    protected List<String> contentSources;

    @JsonProperty("contentSources@nextLink")
    protected String contentSourcesNextLink;

    @JsonProperty("enableTopResults")
    protected Boolean enableTopResults;

    @JsonProperty("entityTypes")
    protected List<EntityType> entityTypes;

    @JsonProperty("entityTypes@nextLink")
    protected String entityTypesNextLink;

    @JsonProperty("fields")
    protected List<String> fields;

    @JsonProperty("fields@nextLink")
    protected String fieldsNextLink;

    @JsonProperty("from")
    protected Integer from;

    @JsonProperty("query")
    protected SearchQuery query;

    @JsonProperty("queryAlterationOptions")
    protected SearchAlterationOptions queryAlterationOptions;

    @JsonProperty("resultTemplateOptions")
    protected ResultTemplateOption resultTemplateOptions;

    @JsonProperty("size")
    protected Integer size;

    @JsonProperty("sortProperties")
    protected List<SortProperty> sortProperties;

    @JsonProperty("sortProperties@nextLink")
    protected String sortPropertiesNextLink;

    @JsonProperty("stored_fields")
    protected List<String> stored_fields;

    @JsonProperty("stored_fields@nextLink")
    protected String stored_fieldsNextLink;

    @JsonProperty("trimDuplicates")
    protected Boolean trimDuplicates;

    protected SearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchRequest";
    }

    @Property(name="aggregationFilters")
    @JsonIgnore
    public CollectionPage<String> getAggregationFilters() {
        return new CollectionPage<String>(contextPath, String.class, this.aggregationFilters, Optional.ofNullable(aggregationFiltersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="aggregationFilters")
    @JsonIgnore
    public CollectionPage<String> getAggregationFilters(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.aggregationFilters, Optional.ofNullable(aggregationFiltersNextLink), Collections.emptyList(), options);
    }

    @Property(name="aggregations")
    @JsonIgnore
    public CollectionPage<AggregationOption> getAggregations() {
        return new CollectionPage<AggregationOption>(contextPath, AggregationOption.class, this.aggregations, Optional.ofNullable(aggregationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="aggregations")
    @JsonIgnore
    public CollectionPage<AggregationOption> getAggregations(HttpRequestOptions options) {
        return new CollectionPage<AggregationOption>(contextPath, AggregationOption.class, this.aggregations, Optional.ofNullable(aggregationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="contentSources")
    @JsonIgnore
    public CollectionPage<String> getContentSources() {
        return new CollectionPage<String>(contextPath, String.class, this.contentSources, Optional.ofNullable(contentSourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="contentSources")
    @JsonIgnore
    public CollectionPage<String> getContentSources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.contentSources, Optional.ofNullable(contentSourcesNextLink), Collections.emptyList(), options);
    }

    @Property(name="enableTopResults")
    @JsonIgnore
    public Optional<Boolean> getEnableTopResults() {
        return Optional.ofNullable(enableTopResults);
    }

    public SearchRequest withEnableTopResults(Boolean enableTopResults) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.enableTopResults = enableTopResults;
        return _x;
    }

    @Property(name="entityTypes")
    @JsonIgnore
    public CollectionPage<EntityType> getEntityTypes() {
        return new CollectionPage<EntityType>(contextPath, EntityType.class, this.entityTypes, Optional.ofNullable(entityTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="entityTypes")
    @JsonIgnore
    public CollectionPage<EntityType> getEntityTypes(HttpRequestOptions options) {
        return new CollectionPage<EntityType>(contextPath, EntityType.class, this.entityTypes, Optional.ofNullable(entityTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields() {
        return new CollectionPage<String>(contextPath, String.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), options);
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<Integer> getFrom() {
        return Optional.ofNullable(from);
    }

    public SearchRequest withFrom(Integer from) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.from = from;
        return _x;
    }

    @Property(name="query")
    @JsonIgnore
    public Optional<SearchQuery> getQuery() {
        return Optional.ofNullable(query);
    }

    public SearchRequest withQuery(SearchQuery query) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.query = query;
        return _x;
    }

    @Property(name="queryAlterationOptions")
    @JsonIgnore
    public Optional<SearchAlterationOptions> getQueryAlterationOptions() {
        return Optional.ofNullable(queryAlterationOptions);
    }

    public SearchRequest withQueryAlterationOptions(SearchAlterationOptions queryAlterationOptions) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.queryAlterationOptions = queryAlterationOptions;
        return _x;
    }

    @Property(name="resultTemplateOptions")
    @JsonIgnore
    public Optional<ResultTemplateOption> getResultTemplateOptions() {
        return Optional.ofNullable(resultTemplateOptions);
    }

    public SearchRequest withResultTemplateOptions(ResultTemplateOption resultTemplateOptions) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.resultTemplateOptions = resultTemplateOptions;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    public SearchRequest withSize(Integer size) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.size = size;
        return _x;
    }

    @Property(name="sortProperties")
    @JsonIgnore
    public CollectionPage<SortProperty> getSortProperties() {
        return new CollectionPage<SortProperty>(contextPath, SortProperty.class, this.sortProperties, Optional.ofNullable(sortPropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sortProperties")
    @JsonIgnore
    public CollectionPage<SortProperty> getSortProperties(HttpRequestOptions options) {
        return new CollectionPage<SortProperty>(contextPath, SortProperty.class, this.sortProperties, Optional.ofNullable(sortPropertiesNextLink), Collections.emptyList(), options);
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property stored_fields
     */
    @Property(name="stored_fields")
    @JsonIgnore
    public CollectionPage<String> getStored_fields() {
        return new CollectionPage<String>(contextPath, String.class, this.stored_fields, Optional.ofNullable(stored_fieldsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property stored_fields
     */
    @Property(name="stored_fields")
    @JsonIgnore
    public CollectionPage<String> getStored_fields(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.stored_fields, Optional.ofNullable(stored_fieldsNextLink), Collections.emptyList(), options);
    }

    @Property(name="trimDuplicates")
    @JsonIgnore
    public Optional<Boolean> getTrimDuplicates() {
        return Optional.ofNullable(trimDuplicates);
    }

    public SearchRequest withTrimDuplicates(Boolean trimDuplicates) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.trimDuplicates = trimDuplicates;
        return _x;
    }

    public SearchRequest withUnmappedField(String name, Object value) {
        SearchRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> aggregationFilters;
        private String aggregationFiltersNextLink;
        private List<AggregationOption> aggregations;
        private String aggregationsNextLink;
        private List<String> contentSources;
        private String contentSourcesNextLink;
        private Boolean enableTopResults;
        private List<EntityType> entityTypes;
        private String entityTypesNextLink;
        private List<String> fields;
        private String fieldsNextLink;
        private Integer from;
        private SearchQuery query;
        private SearchAlterationOptions queryAlterationOptions;
        private ResultTemplateOption resultTemplateOptions;
        private Integer size;
        private List<SortProperty> sortProperties;
        private String sortPropertiesNextLink;
        private List<String> stored_fields;
        private String stored_fieldsNextLink;
        private Boolean trimDuplicates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder aggregationFilters(List<String> aggregationFilters) {
            this.aggregationFilters = aggregationFilters;
            this.changedFields = changedFields.add("aggregationFilters");
            return this;
        }

        public Builder aggregationFilters(String... aggregationFilters) {
            return aggregationFilters(Arrays.asList(aggregationFilters));
        }

        public Builder aggregationFiltersNextLink(String aggregationFiltersNextLink) {
            this.aggregationFiltersNextLink = aggregationFiltersNextLink;
            this.changedFields = changedFields.add("aggregationFilters");
            return this;
        }

        public Builder aggregations(List<AggregationOption> aggregations) {
            this.aggregations = aggregations;
            this.changedFields = changedFields.add("aggregations");
            return this;
        }

        public Builder aggregations(AggregationOption... aggregations) {
            return aggregations(Arrays.asList(aggregations));
        }

        public Builder aggregationsNextLink(String aggregationsNextLink) {
            this.aggregationsNextLink = aggregationsNextLink;
            this.changedFields = changedFields.add("aggregations");
            return this;
        }

        public Builder contentSources(List<String> contentSources) {
            this.contentSources = contentSources;
            this.changedFields = changedFields.add("contentSources");
            return this;
        }

        public Builder contentSources(String... contentSources) {
            return contentSources(Arrays.asList(contentSources));
        }

        public Builder contentSourcesNextLink(String contentSourcesNextLink) {
            this.contentSourcesNextLink = contentSourcesNextLink;
            this.changedFields = changedFields.add("contentSources");
            return this;
        }

        public Builder enableTopResults(Boolean enableTopResults) {
            this.enableTopResults = enableTopResults;
            this.changedFields = changedFields.add("enableTopResults");
            return this;
        }

        public Builder entityTypes(List<EntityType> entityTypes) {
            this.entityTypes = entityTypes;
            this.changedFields = changedFields.add("entityTypes");
            return this;
        }

        public Builder entityTypes(EntityType... entityTypes) {
            return entityTypes(Arrays.asList(entityTypes));
        }

        public Builder entityTypesNextLink(String entityTypesNextLink) {
            this.entityTypesNextLink = entityTypesNextLink;
            this.changedFields = changedFields.add("entityTypes");
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fields(String... fields) {
            return fields(Arrays.asList(fields));
        }

        public Builder fieldsNextLink(String fieldsNextLink) {
            this.fieldsNextLink = fieldsNextLink;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder from(Integer from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder query(SearchQuery query) {
            this.query = query;
            this.changedFields = changedFields.add("query");
            return this;
        }

        public Builder queryAlterationOptions(SearchAlterationOptions queryAlterationOptions) {
            this.queryAlterationOptions = queryAlterationOptions;
            this.changedFields = changedFields.add("queryAlterationOptions");
            return this;
        }

        public Builder resultTemplateOptions(ResultTemplateOption resultTemplateOptions) {
            this.resultTemplateOptions = resultTemplateOptions;
            this.changedFields = changedFields.add("resultTemplateOptions");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder sortProperties(List<SortProperty> sortProperties) {
            this.sortProperties = sortProperties;
            this.changedFields = changedFields.add("sortProperties");
            return this;
        }

        public Builder sortProperties(SortProperty... sortProperties) {
            return sortProperties(Arrays.asList(sortProperties));
        }

        public Builder sortPropertiesNextLink(String sortPropertiesNextLink) {
            this.sortPropertiesNextLink = sortPropertiesNextLink;
            this.changedFields = changedFields.add("sortProperties");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param stored_fields
         *            value of {@code stored_fields} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stored_fields(List<String> stored_fields) {
            this.stored_fields = stored_fields;
            this.changedFields = changedFields.add("stored_fields");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param stored_fields
         *            value of {@code stored_fields} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stored_fields(String... stored_fields) {
            return stored_fields(Arrays.asList(stored_fields));
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param stored_fieldsNextLink
         *            value of {@code stored_fields@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stored_fieldsNextLink(String stored_fieldsNextLink) {
            this.stored_fieldsNextLink = stored_fieldsNextLink;
            this.changedFields = changedFields.add("stored_fields");
            return this;
        }

        public Builder trimDuplicates(Boolean trimDuplicates) {
            this.trimDuplicates = trimDuplicates;
            this.changedFields = changedFields.add("trimDuplicates");
            return this;
        }

        public SearchRequest build() {
            SearchRequest _x = new SearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchRequest";
            _x.aggregationFilters = aggregationFilters;
            _x.aggregationFiltersNextLink = aggregationFiltersNextLink;
            _x.aggregations = aggregations;
            _x.aggregationsNextLink = aggregationsNextLink;
            _x.contentSources = contentSources;
            _x.contentSourcesNextLink = contentSourcesNextLink;
            _x.enableTopResults = enableTopResults;
            _x.entityTypes = entityTypes;
            _x.entityTypesNextLink = entityTypesNextLink;
            _x.fields = fields;
            _x.fieldsNextLink = fieldsNextLink;
            _x.from = from;
            _x.query = query;
            _x.queryAlterationOptions = queryAlterationOptions;
            _x.resultTemplateOptions = resultTemplateOptions;
            _x.size = size;
            _x.sortProperties = sortProperties;
            _x.sortPropertiesNextLink = sortPropertiesNextLink;
            _x.stored_fields = stored_fields;
            _x.stored_fieldsNextLink = stored_fieldsNextLink;
            _x.trimDuplicates = trimDuplicates;
            return _x;
        }
    }

    private SearchRequest _copy() {
        SearchRequest _x = new SearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.aggregationFilters = aggregationFilters;
        _x.aggregations = aggregations;
        _x.contentSources = contentSources;
        _x.enableTopResults = enableTopResults;
        _x.entityTypes = entityTypes;
        _x.fields = fields;
        _x.from = from;
        _x.query = query;
        _x.queryAlterationOptions = queryAlterationOptions;
        _x.resultTemplateOptions = resultTemplateOptions;
        _x.size = size;
        _x.sortProperties = sortProperties;
        _x.stored_fields = stored_fields;
        _x.trimDuplicates = trimDuplicates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchRequest[");
        b.append("aggregationFilters=");
        b.append(this.aggregationFilters);
        b.append(", ");
        b.append("aggregations=");
        b.append(this.aggregations);
        b.append(", ");
        b.append("contentSources=");
        b.append(this.contentSources);
        b.append(", ");
        b.append("enableTopResults=");
        b.append(this.enableTopResults);
        b.append(", ");
        b.append("entityTypes=");
        b.append(this.entityTypes);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("query=");
        b.append(this.query);
        b.append(", ");
        b.append("queryAlterationOptions=");
        b.append(this.queryAlterationOptions);
        b.append(", ");
        b.append("resultTemplateOptions=");
        b.append(this.resultTemplateOptions);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("sortProperties=");
        b.append(this.sortProperties);
        b.append(", ");
        b.append("stored_fields=");
        b.append(this.stored_fields);
        b.append(", ");
        b.append("trimDuplicates=");
        b.append(this.trimDuplicates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
