package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "queryString", 
    "queryTemplate", 
    "query_string"})
@JsonInclude(Include.NON_NULL)
public class SearchQuery implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("queryString")
    protected String queryString;

    @JsonProperty("queryTemplate")
    protected String queryTemplate;

    @JsonProperty("query_string")
    protected SearchQueryString query_string;

    protected SearchQuery() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchQuery";
    }

    @Property(name="queryString")
    @JsonIgnore
    public Optional<String> getQueryString() {
        return Optional.ofNullable(queryString);
    }

    public SearchQuery withQueryString(String queryString) {
        SearchQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchQuery");
        _x.queryString = queryString;
        return _x;
    }

    @Property(name="queryTemplate")
    @JsonIgnore
    public Optional<String> getQueryTemplate() {
        return Optional.ofNullable(queryTemplate);
    }

    public SearchQuery withQueryTemplate(String queryTemplate) {
        SearchQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchQuery");
        _x.queryTemplate = queryTemplate;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property query_string
     */
    @Property(name="query_string")
    @JsonIgnore
    public Optional<SearchQueryString> getQuery_string() {
        return Optional.ofNullable(query_string);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code query_string}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param query_string
     *            new value of {@code query_string} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code query_string} field changed
     */
    public SearchQuery withQuery_string(SearchQueryString query_string) {
        SearchQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchQuery");
        _x.query_string = query_string;
        return _x;
    }

    public SearchQuery withUnmappedField(String name, Object value) {
        SearchQuery _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String queryString;
        private String queryTemplate;
        private SearchQueryString query_string;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            this.changedFields = changedFields.add("queryString");
            return this;
        }

        public Builder queryTemplate(String queryTemplate) {
            this.queryTemplate = queryTemplate;
            this.changedFields = changedFields.add("queryTemplate");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param query_string
         *            value of {@code query_string} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder query_string(SearchQueryString query_string) {
            this.query_string = query_string;
            this.changedFields = changedFields.add("query_string");
            return this;
        }

        public SearchQuery build() {
            SearchQuery _x = new SearchQuery();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchQuery";
            _x.queryString = queryString;
            _x.queryTemplate = queryTemplate;
            _x.query_string = query_string;
            return _x;
        }
    }

    private SearchQuery _copy() {
        SearchQuery _x = new SearchQuery();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.queryString = queryString;
        _x.queryTemplate = queryTemplate;
        _x.query_string = query_string;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchQuery[");
        b.append("queryString=");
        b.append(this.queryString);
        b.append(", ");
        b.append("queryTemplate=");
        b.append(this.queryTemplate);
        b.append(", ");
        b.append("query_string=");
        b.append(this.query_string);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
