package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "aggregationFilterToken", 
    "count", 
    "key"})
@JsonInclude(Include.NON_NULL)
public class SearchBucket implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("aggregationFilterToken")
    protected String aggregationFilterToken;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("key")
    protected String key;

    protected SearchBucket() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchBucket";
    }

    @Property(name="aggregationFilterToken")
    @JsonIgnore
    public Optional<String> getAggregationFilterToken() {
        return Optional.ofNullable(aggregationFilterToken);
    }

    public SearchBucket withAggregationFilterToken(String aggregationFilterToken) {
        SearchBucket _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchBucket");
        _x.aggregationFilterToken = aggregationFilterToken;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public SearchBucket withCount(Integer count) {
        SearchBucket _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchBucket");
        _x.count = count;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public SearchBucket withKey(String key) {
        SearchBucket _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchBucket");
        _x.key = key;
        return _x;
    }

    public SearchBucket withUnmappedField(String name, Object value) {
        SearchBucket _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String aggregationFilterToken;
        private Integer count;
        private String key;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder aggregationFilterToken(String aggregationFilterToken) {
            this.aggregationFilterToken = aggregationFilterToken;
            this.changedFields = changedFields.add("aggregationFilterToken");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public SearchBucket build() {
            SearchBucket _x = new SearchBucket();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchBucket";
            _x.aggregationFilterToken = aggregationFilterToken;
            _x.count = count;
            _x.key = key;
            return _x;
        }
    }

    private SearchBucket _copy() {
        SearchBucket _x = new SearchBucket();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.aggregationFilterToken = aggregationFilterToken;
        _x.count = count;
        _x.key = key;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchBucket[");
        b.append("aggregationFilterToken=");
        b.append(this.aggregationFilterToken);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
