package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enableModification", 
    "enableSuggestion"})
@JsonInclude(Include.NON_NULL)
public class SearchAlterationOptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enableModification")
    protected Boolean enableModification;

    @JsonProperty("enableSuggestion")
    protected Boolean enableSuggestion;

    protected SearchAlterationOptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchAlterationOptions";
    }

    @Property(name="enableModification")
    @JsonIgnore
    public Optional<Boolean> getEnableModification() {
        return Optional.ofNullable(enableModification);
    }

    public SearchAlterationOptions withEnableModification(Boolean enableModification) {
        SearchAlterationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchAlterationOptions");
        _x.enableModification = enableModification;
        return _x;
    }

    @Property(name="enableSuggestion")
    @JsonIgnore
    public Optional<Boolean> getEnableSuggestion() {
        return Optional.ofNullable(enableSuggestion);
    }

    public SearchAlterationOptions withEnableSuggestion(Boolean enableSuggestion) {
        SearchAlterationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchAlterationOptions");
        _x.enableSuggestion = enableSuggestion;
        return _x;
    }

    public SearchAlterationOptions withUnmappedField(String name, Object value) {
        SearchAlterationOptions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean enableModification;
        private Boolean enableSuggestion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder enableModification(Boolean enableModification) {
            this.enableModification = enableModification;
            this.changedFields = changedFields.add("enableModification");
            return this;
        }

        public Builder enableSuggestion(Boolean enableSuggestion) {
            this.enableSuggestion = enableSuggestion;
            this.changedFields = changedFields.add("enableSuggestion");
            return this;
        }

        public SearchAlterationOptions build() {
            SearchAlterationOptions _x = new SearchAlterationOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchAlterationOptions";
            _x.enableModification = enableModification;
            _x.enableSuggestion = enableSuggestion;
            return _x;
        }
    }

    private SearchAlterationOptions _copy() {
        SearchAlterationOptions _x = new SearchAlterationOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enableModification = enableModification;
        _x.enableSuggestion = enableSuggestion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchAlterationOptions[");
        b.append("enableModification=");
        b.append(this.enableModification);
        b.append(", ");
        b.append("enableSuggestion=");
        b.append(this.enableSuggestion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
