package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Float;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "criteria", 
    "description", 
    "displayName", 
    "qualityId", 
    "weight"})
@JsonInclude(Include.NON_NULL)
public class RubricQuality implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("criteria")
    protected List<RubricCriterion> criteria;

    @JsonProperty("criteria@nextLink")
    protected String criteriaNextLink;

    @JsonProperty("description")
    protected EducationItemBody description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("qualityId")
    protected String qualityId;

    @JsonProperty("weight")
    protected Float weight;

    protected RubricQuality() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rubricQuality";
    }

    @Property(name="criteria")
    @JsonIgnore
    public CollectionPage<RubricCriterion> getCriteria() {
        return new CollectionPage<RubricCriterion>(contextPath, RubricCriterion.class, this.criteria, Optional.ofNullable(criteriaNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="criteria")
    @JsonIgnore
    public CollectionPage<RubricCriterion> getCriteria(HttpRequestOptions options) {
        return new CollectionPage<RubricCriterion>(contextPath, RubricCriterion.class, this.criteria, Optional.ofNullable(criteriaNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<EducationItemBody> getDescription() {
        return Optional.ofNullable(description);
    }

    public RubricQuality withDescription(EducationItemBody description) {
        RubricQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQuality");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RubricQuality withDisplayName(String displayName) {
        RubricQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQuality");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="qualityId")
    @JsonIgnore
    public Optional<String> getQualityId() {
        return Optional.ofNullable(qualityId);
    }

    public RubricQuality withQualityId(String qualityId) {
        RubricQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQuality");
        _x.qualityId = qualityId;
        return _x;
    }

    @Property(name="weight")
    @JsonIgnore
    public Optional<Float> getWeight() {
        return Optional.ofNullable(weight);
    }

    public RubricQuality withWeight(Float weight) {
        RubricQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQuality");
        _x.weight = weight;
        return _x;
    }

    public RubricQuality withUnmappedField(String name, Object value) {
        RubricQuality _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RubricCriterion> criteria;
        private String criteriaNextLink;
        private EducationItemBody description;
        private String displayName;
        private String qualityId;
        private Float weight;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder criteria(List<RubricCriterion> criteria) {
            this.criteria = criteria;
            this.changedFields = changedFields.add("criteria");
            return this;
        }

        public Builder criteria(RubricCriterion... criteria) {
            return criteria(Arrays.asList(criteria));
        }

        public Builder criteriaNextLink(String criteriaNextLink) {
            this.criteriaNextLink = criteriaNextLink;
            this.changedFields = changedFields.add("criteria");
            return this;
        }

        public Builder description(EducationItemBody description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder qualityId(String qualityId) {
            this.qualityId = qualityId;
            this.changedFields = changedFields.add("qualityId");
            return this;
        }

        public Builder weight(Float weight) {
            this.weight = weight;
            this.changedFields = changedFields.add("weight");
            return this;
        }

        public RubricQuality build() {
            RubricQuality _x = new RubricQuality();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rubricQuality";
            _x.criteria = criteria;
            _x.criteriaNextLink = criteriaNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.qualityId = qualityId;
            _x.weight = weight;
            return _x;
        }
    }

    private RubricQuality _copy() {
        RubricQuality _x = new RubricQuality();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.criteria = criteria;
        _x.description = description;
        _x.displayName = displayName;
        _x.qualityId = qualityId;
        _x.weight = weight;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RubricQuality[");
        b.append("criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("qualityId=");
        b.append(this.qualityId);
        b.append(", ");
        b.append("weight=");
        b.append(this.weight);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
