package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "grading", 
    "levelId"})
@JsonInclude(Include.NON_NULL)
public class RubricLevel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected EducationItemBody description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("grading")
    protected EducationAssignmentGradeType grading;

    @JsonProperty("levelId")
    protected String levelId;

    protected RubricLevel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rubricLevel";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<EducationItemBody> getDescription() {
        return Optional.ofNullable(description);
    }

    public RubricLevel withDescription(EducationItemBody description) {
        RubricLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricLevel");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RubricLevel withDisplayName(String displayName) {
        RubricLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricLevel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="grading")
    @JsonIgnore
    public Optional<EducationAssignmentGradeType> getGrading() {
        return Optional.ofNullable(grading);
    }

    public RubricLevel withGrading(EducationAssignmentGradeType grading) {
        RubricLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricLevel");
        _x.grading = grading;
        return _x;
    }

    @Property(name="levelId")
    @JsonIgnore
    public Optional<String> getLevelId() {
        return Optional.ofNullable(levelId);
    }

    public RubricLevel withLevelId(String levelId) {
        RubricLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricLevel");
        _x.levelId = levelId;
        return _x;
    }

    public RubricLevel withUnmappedField(String name, Object value) {
        RubricLevel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationItemBody description;
        private String displayName;
        private EducationAssignmentGradeType grading;
        private String levelId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(EducationItemBody description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder grading(EducationAssignmentGradeType grading) {
            this.grading = grading;
            this.changedFields = changedFields.add("grading");
            return this;
        }

        public Builder levelId(String levelId) {
            this.levelId = levelId;
            this.changedFields = changedFields.add("levelId");
            return this;
        }

        public RubricLevel build() {
            RubricLevel _x = new RubricLevel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rubricLevel";
            _x.description = description;
            _x.displayName = displayName;
            _x.grading = grading;
            _x.levelId = levelId;
            return _x;
        }
    }

    private RubricLevel _copy() {
        RubricLevel _x = new RubricLevel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.grading = grading;
        _x.levelId = levelId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RubricLevel[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("grading=");
        b.append(this.grading);
        b.append(", ");
        b.append("levelId=");
        b.append(this.levelId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
