package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Contains the set of ResourceActions determining the allowed and not allowed
 * permissions for each role.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "actions", 
    "resourceActions"})
@JsonInclude(Include.NON_NULL)
public class RolePermission implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actions")
    protected List<String> actions;

    @JsonProperty("actions@nextLink")
    protected String actionsNextLink;

    @JsonProperty("resourceActions")
    protected List<ResourceAction> resourceActions;

    @JsonProperty("resourceActions@nextLink")
    protected String resourceActionsNextLink;

    protected RolePermission() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rolePermission";
    }

    /**
     * <i>“Allowed Actions - Deprecated”</i>
     * 
     * @return property actions
     */
    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<String> getActions() {
        return new CollectionPage<String>(contextPath, String.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Allowed Actions - Deprecated”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property actions
     */
    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<String> getActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Resource Actions each containing a set of allowed and not allowed permissions.”</i>
     * 
     * @return property resourceActions
     */
    @Property(name="resourceActions")
    @JsonIgnore
    public CollectionPage<ResourceAction> getResourceActions() {
        return new CollectionPage<ResourceAction>(contextPath, ResourceAction.class, this.resourceActions, Optional.ofNullable(resourceActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Resource Actions each containing a set of allowed and not allowed permissions.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property resourceActions
     */
    @Property(name="resourceActions")
    @JsonIgnore
    public CollectionPage<ResourceAction> getResourceActions(HttpRequestOptions options) {
        return new CollectionPage<ResourceAction>(contextPath, ResourceAction.class, this.resourceActions, Optional.ofNullable(resourceActionsNextLink), Collections.emptyList(), options);
    }

    public RolePermission withUnmappedField(String name, Object value) {
        RolePermission _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> actions;
        private String actionsNextLink;
        private List<ResourceAction> resourceActions;
        private String resourceActionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Allowed Actions - Deprecated”</i>
         * 
         * @param actions
         *            value of {@code actions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actions(List<String> actions) {
            this.actions = actions;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        /**
         * <i>“Allowed Actions - Deprecated”</i>
         * 
         * @param actions
         *            value of {@code actions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actions(String... actions) {
            return actions(Arrays.asList(actions));
        }

        /**
         * <i>“Allowed Actions - Deprecated”</i>
         * 
         * @param actionsNextLink
         *            value of {@code actions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionsNextLink(String actionsNextLink) {
            this.actionsNextLink = actionsNextLink;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        /**
         * <i>“Resource Actions each containing a set of allowed and not allowed permissions.”</i>
         * 
         * @param resourceActions
         *            value of {@code resourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceActions(List<ResourceAction> resourceActions) {
            this.resourceActions = resourceActions;
            this.changedFields = changedFields.add("resourceActions");
            return this;
        }

        /**
         * <i>“Resource Actions each containing a set of allowed and not allowed permissions.”</i>
         * 
         * @param resourceActions
         *            value of {@code resourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceActions(ResourceAction... resourceActions) {
            return resourceActions(Arrays.asList(resourceActions));
        }

        /**
         * <i>“Resource Actions each containing a set of allowed and not allowed permissions.”</i>
         * 
         * @param resourceActionsNextLink
         *            value of {@code resourceActions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceActionsNextLink(String resourceActionsNextLink) {
            this.resourceActionsNextLink = resourceActionsNextLink;
            this.changedFields = changedFields.add("resourceActions");
            return this;
        }

        public RolePermission build() {
            RolePermission _x = new RolePermission();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rolePermission";
            _x.actions = actions;
            _x.actionsNextLink = actionsNextLink;
            _x.resourceActions = resourceActions;
            _x.resourceActionsNextLink = resourceActionsNextLink;
            return _x;
        }
    }

    private RolePermission _copy() {
        RolePermission _x = new RolePermission();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actions = actions;
        _x.resourceActions = resourceActions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RolePermission[");
        b.append("actions=");
        b.append(this.actions);
        b.append(", ");
        b.append("resourceActions=");
        b.append(this.resourceActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
