package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "roleId", 
    "roleTemplateId"})
@JsonInclude(Include.NON_NULL)
public class RoleMembershipGovernanceCriteria extends GovernanceCriteria implements ODataType {

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("roleTemplateId")
    protected String roleTemplateId;

    protected RoleMembershipGovernanceCriteria() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleMembershipGovernanceCriteria";
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public RoleMembershipGovernanceCriteria withRoleId(String roleId) {
        RoleMembershipGovernanceCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleMembershipGovernanceCriteria");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="roleTemplateId")
    @JsonIgnore
    public Optional<String> getRoleTemplateId() {
        return Optional.ofNullable(roleTemplateId);
    }

    public RoleMembershipGovernanceCriteria withRoleTemplateId(String roleTemplateId) {
        RoleMembershipGovernanceCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleMembershipGovernanceCriteria");
        _x.roleTemplateId = roleTemplateId;
        return _x;
    }

    public RoleMembershipGovernanceCriteria withUnmappedField(String name, Object value) {
        RoleMembershipGovernanceCriteria _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleMembershipGovernanceCriteria() {
        return new Builder();
    }

    public static final class Builder {
        private String roleId;
        private String roleTemplateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder roleTemplateId(String roleTemplateId) {
            this.roleTemplateId = roleTemplateId;
            this.changedFields = changedFields.add("roleTemplateId");
            return this;
        }

        public RoleMembershipGovernanceCriteria build() {
            RoleMembershipGovernanceCriteria _x = new RoleMembershipGovernanceCriteria();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.roleMembershipGovernanceCriteria";
            _x.roleId = roleId;
            _x.roleTemplateId = roleTemplateId;
            return _x;
        }
    }

    private RoleMembershipGovernanceCriteria _copy() {
        RoleMembershipGovernanceCriteria _x = new RoleMembershipGovernanceCriteria();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.roleId = roleId;
        _x.roleTemplateId = roleTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleMembershipGovernanceCriteria[");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("roleTemplateId=");
        b.append(this.roleTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
