package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Revoke Apple Vpp licenses action result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "failedLicensesCount", 
    "totalLicensesCount"})
@JsonInclude(Include.NON_NULL)
public class RevokeAppleVppLicensesActionResult extends DeviceActionResult implements ODataType {

    @JsonProperty("failedLicensesCount")
    protected Integer failedLicensesCount;

    @JsonProperty("totalLicensesCount")
    protected Integer totalLicensesCount;

    protected RevokeAppleVppLicensesActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.revokeAppleVppLicensesActionResult";
    }

    /**
     * <i>“Total number of Apple Vpp licenses that failed to revoke”</i>
     * 
     * @return property failedLicensesCount
     */
    @Property(name="failedLicensesCount")
    @JsonIgnore
    public Optional<Integer> getFailedLicensesCount() {
        return Optional.ofNullable(failedLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * failedLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total number of Apple Vpp licenses that failed to revoke”</i>
     * 
     * @param failedLicensesCount
     *            new value of {@code failedLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedLicensesCount} field changed
     */
    public RevokeAppleVppLicensesActionResult withFailedLicensesCount(Integer failedLicensesCount) {
        RevokeAppleVppLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.revokeAppleVppLicensesActionResult");
        _x.failedLicensesCount = failedLicensesCount;
        return _x;
    }

    /**
     * <i>“Total number of Apple Vpp licenses associated”</i>
     * 
     * @return property totalLicensesCount
     */
    @Property(name="totalLicensesCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicensesCount() {
        return Optional.ofNullable(totalLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total number of Apple Vpp licenses associated”</i>
     * 
     * @param totalLicensesCount
     *            new value of {@code totalLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicensesCount} field changed
     */
    public RevokeAppleVppLicensesActionResult withTotalLicensesCount(Integer totalLicensesCount) {
        RevokeAppleVppLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.revokeAppleVppLicensesActionResult");
        _x.totalLicensesCount = totalLicensesCount;
        return _x;
    }

    public RevokeAppleVppLicensesActionResult withUnmappedField(String name, Object value) {
        RevokeAppleVppLicensesActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRevokeAppleVppLicensesActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private Integer failedLicensesCount;
        private Integer totalLicensesCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Total number of Apple Vpp licenses that failed to revoke”</i>
         * 
         * @param failedLicensesCount
         *            value of {@code failedLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedLicensesCount(Integer failedLicensesCount) {
            this.failedLicensesCount = failedLicensesCount;
            this.changedFields = changedFields.add("failedLicensesCount");
            return this;
        }

        /**
         * <i>“Total number of Apple Vpp licenses associated”</i>
         * 
         * @param totalLicensesCount
         *            value of {@code totalLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicensesCount(Integer totalLicensesCount) {
            this.totalLicensesCount = totalLicensesCount;
            this.changedFields = changedFields.add("totalLicensesCount");
            return this;
        }

        public RevokeAppleVppLicensesActionResult build() {
            RevokeAppleVppLicensesActionResult _x = new RevokeAppleVppLicensesActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.revokeAppleVppLicensesActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.failedLicensesCount = failedLicensesCount;
            _x.totalLicensesCount = totalLicensesCount;
            return _x;
        }
    }

    private RevokeAppleVppLicensesActionResult _copy() {
        RevokeAppleVppLicensesActionResult _x = new RevokeAppleVppLicensesActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.failedLicensesCount = failedLicensesCount;
        _x.totalLicensesCount = totalLicensesCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RevokeAppleVppLicensesActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("failedLicensesCount=");
        b.append(this.failedLicensesCount);
        b.append(", ");
        b.append("totalLicensesCount=");
        b.append(this.totalLicensesCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
