package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceAccess", 
    "resourceAppId"})
@JsonInclude(Include.NON_NULL)
public class RequiredResourceAccess implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("resourceAccess")
    protected List<ResourceAccess> resourceAccess;

    @JsonProperty("resourceAccess@nextLink")
    protected String resourceAccessNextLink;

    @JsonProperty("resourceAppId")
    protected String resourceAppId;

    protected RequiredResourceAccess() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.requiredResourceAccess";
    }

    @Property(name="resourceAccess")
    @JsonIgnore
    public CollectionPage<ResourceAccess> getResourceAccess() {
        return new CollectionPage<ResourceAccess>(contextPath, ResourceAccess.class, this.resourceAccess, Optional.ofNullable(resourceAccessNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="resourceAccess")
    @JsonIgnore
    public CollectionPage<ResourceAccess> getResourceAccess(HttpRequestOptions options) {
        return new CollectionPage<ResourceAccess>(contextPath, ResourceAccess.class, this.resourceAccess, Optional.ofNullable(resourceAccessNextLink), Collections.emptyList(), options);
    }

    @Property(name="resourceAppId")
    @JsonIgnore
    public Optional<String> getResourceAppId() {
        return Optional.ofNullable(resourceAppId);
    }

    public RequiredResourceAccess withResourceAppId(String resourceAppId) {
        RequiredResourceAccess _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requiredResourceAccess");
        _x.resourceAppId = resourceAppId;
        return _x;
    }

    public RequiredResourceAccess withUnmappedField(String name, Object value) {
        RequiredResourceAccess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceAccess> resourceAccess;
        private String resourceAccessNextLink;
        private String resourceAppId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resourceAccess(List<ResourceAccess> resourceAccess) {
            this.resourceAccess = resourceAccess;
            this.changedFields = changedFields.add("resourceAccess");
            return this;
        }

        public Builder resourceAccess(ResourceAccess... resourceAccess) {
            return resourceAccess(Arrays.asList(resourceAccess));
        }

        public Builder resourceAccessNextLink(String resourceAccessNextLink) {
            this.resourceAccessNextLink = resourceAccessNextLink;
            this.changedFields = changedFields.add("resourceAccess");
            return this;
        }

        public Builder resourceAppId(String resourceAppId) {
            this.resourceAppId = resourceAppId;
            this.changedFields = changedFields.add("resourceAppId");
            return this;
        }

        public RequiredResourceAccess build() {
            RequiredResourceAccess _x = new RequiredResourceAccess();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.requiredResourceAccess";
            _x.resourceAccess = resourceAccess;
            _x.resourceAccessNextLink = resourceAccessNextLink;
            _x.resourceAppId = resourceAppId;
            return _x;
        }
    }

    private RequiredResourceAccess _copy() {
        RequiredResourceAccess _x = new RequiredResourceAccess();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceAccess = resourceAccess;
        _x.resourceAppId = resourceAppId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequiredResourceAccess[");
        b.append("resourceAccess=");
        b.append(this.resourceAccess);
        b.append(", ");
        b.append("resourceAppId=");
        b.append(this.resourceAppId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
