package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "managerLevel"})
@JsonInclude(Include.NON_NULL)
public class RequestorManager extends UserSet implements ODataType {

    @JsonProperty("managerLevel")
    protected Integer managerLevel;

    protected RequestorManager() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.requestorManager";
    }

    @Property(name="managerLevel")
    @JsonIgnore
    public Optional<Integer> getManagerLevel() {
        return Optional.ofNullable(managerLevel);
    }

    public RequestorManager withManagerLevel(Integer managerLevel) {
        RequestorManager _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestorManager");
        _x.managerLevel = managerLevel;
        return _x;
    }

    public RequestorManager withUnmappedField(String name, Object value) {
        RequestorManager _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRequestorManager() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isBackup;
        private Integer managerLevel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isBackup(Boolean isBackup) {
            this.isBackup = isBackup;
            this.changedFields = changedFields.add("isBackup");
            return this;
        }

        public Builder managerLevel(Integer managerLevel) {
            this.managerLevel = managerLevel;
            this.changedFields = changedFields.add("managerLevel");
            return this;
        }

        public RequestorManager build() {
            RequestorManager _x = new RequestorManager();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.requestorManager";
            _x.isBackup = isBackup;
            _x.managerLevel = managerLevel;
            return _x;
        }
    }

    private RequestorManager _copy() {
        RequestorManager _x = new RequestorManager();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isBackup = isBackup;
        _x.managerLevel = managerLevel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequestorManager[");
        b.append("isBackup=");
        b.append(this.isBackup);
        b.append(", ");
        b.append("managerLevel=");
        b.append(this.managerLevel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
