package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Device Configuration profile History reports.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "content"})
@JsonInclude(Include.NON_NULL)
public class Report implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("content")
    protected String content;

    protected Report() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.report";
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> patchContent() {
        return patchContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> patchChunkedContent() {
        return patchContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> patchContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> postContent() {
        return postContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> postChunkedContent() {
        return postContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> postContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PUT);
    }

    public Report withUnmappedField(String name, Object value) {
        Report _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Report build() {
            Report _x = new Report();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.report";
            _x.content = content;
            return _x;
        }
    }

    private Report _copy() {
        Report _x = new Report();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.content = content;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Report[");
        b.append("content=");
        b.append(this.content);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
