package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "uiElementNames"})
@JsonInclude(Include.NON_NULL)
public class RemoveWatermarkAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("uiElementNames")
    protected List<String> uiElementNames;

    @JsonProperty("uiElementNames@nextLink")
    protected String uiElementNamesNextLink;

    protected RemoveWatermarkAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.removeWatermarkAction";
    }

    @Property(name="uiElementNames")
    @JsonIgnore
    public CollectionPage<String> getUiElementNames() {
        return new CollectionPage<String>(contextPath, String.class, this.uiElementNames, Optional.ofNullable(uiElementNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="uiElementNames")
    @JsonIgnore
    public CollectionPage<String> getUiElementNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.uiElementNames, Optional.ofNullable(uiElementNamesNextLink), Collections.emptyList(), options);
    }

    public RemoveWatermarkAction withUnmappedField(String name, Object value) {
        RemoveWatermarkAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoveWatermarkAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> uiElementNames;
        private String uiElementNamesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder uiElementNames(List<String> uiElementNames) {
            this.uiElementNames = uiElementNames;
            this.changedFields = changedFields.add("uiElementNames");
            return this;
        }

        public Builder uiElementNames(String... uiElementNames) {
            return uiElementNames(Arrays.asList(uiElementNames));
        }

        public Builder uiElementNamesNextLink(String uiElementNamesNextLink) {
            this.uiElementNamesNextLink = uiElementNamesNextLink;
            this.changedFields = changedFields.add("uiElementNames");
            return this;
        }

        public RemoveWatermarkAction build() {
            RemoveWatermarkAction _x = new RemoveWatermarkAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.removeWatermarkAction";
            _x.uiElementNames = uiElementNames;
            _x.uiElementNamesNextLink = uiElementNamesNextLink;
            return _x;
        }
    }

    private RemoveWatermarkAction _copy() {
        RemoveWatermarkAction _x = new RemoveWatermarkAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.uiElementNames = uiElementNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoveWatermarkAction[");
        b.append("uiElementNames=");
        b.append(this.uiElementNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
