package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "index", 
    "uri"})
@JsonInclude(Include.NON_NULL)
public class RedirectUriSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("index")
    protected Integer index;

    @JsonProperty("uri")
    protected String uri;

    protected RedirectUriSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.redirectUriSettings";
    }

    @Property(name="index")
    @JsonIgnore
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    public RedirectUriSettings withIndex(Integer index) {
        RedirectUriSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.redirectUriSettings");
        _x.index = index;
        return _x;
    }

    @Property(name="uri")
    @JsonIgnore
    public Optional<String> getUri() {
        return Optional.ofNullable(uri);
    }

    public RedirectUriSettings withUri(String uri) {
        RedirectUriSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.redirectUriSettings");
        _x.uri = uri;
        return _x;
    }

    public RedirectUriSettings withUnmappedField(String name, Object value) {
        RedirectUriSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer index;
        private String uri;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder index(Integer index) {
            this.index = index;
            this.changedFields = changedFields.add("index");
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            this.changedFields = changedFields.add("uri");
            return this;
        }

        public RedirectUriSettings build() {
            RedirectUriSettings _x = new RedirectUriSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.redirectUriSettings";
            _x.index = index;
            _x.uri = uri;
            return _x;
        }
    }

    private RedirectUriSettings _copy() {
        RedirectUriSettings _x = new RedirectUriSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.index = index;
        _x.uri = uri;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RedirectUriSettings[");
        b.append("index=");
        b.append(this.index);
        b.append(", ");
        b.append("uri=");
        b.append(this.uri);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
