package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "actionWebUrl", 
    "potentialScoreImpact", 
    "title"})
@JsonInclude(Include.NON_NULL)
public class RecommendedAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionWebUrl")
    protected String actionWebUrl;

    @JsonProperty("potentialScoreImpact")
    protected Double potentialScoreImpact;

    @JsonProperty("title")
    protected String title;

    protected RecommendedAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recommendedAction";
    }

    @Property(name="actionWebUrl")
    @JsonIgnore
    public Optional<String> getActionWebUrl() {
        return Optional.ofNullable(actionWebUrl);
    }

    public RecommendedAction withActionWebUrl(String actionWebUrl) {
        RecommendedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendedAction");
        _x.actionWebUrl = actionWebUrl;
        return _x;
    }

    @Property(name="potentialScoreImpact")
    @JsonIgnore
    public Optional<Double> getPotentialScoreImpact() {
        return Optional.ofNullable(potentialScoreImpact);
    }

    public RecommendedAction withPotentialScoreImpact(Double potentialScoreImpact) {
        RecommendedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendedAction");
        _x.potentialScoreImpact = potentialScoreImpact;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public RecommendedAction withTitle(String title) {
        RecommendedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendedAction");
        _x.title = title;
        return _x;
    }

    public RecommendedAction withUnmappedField(String name, Object value) {
        RecommendedAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actionWebUrl;
        private Double potentialScoreImpact;
        private String title;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionWebUrl(String actionWebUrl) {
            this.actionWebUrl = actionWebUrl;
            this.changedFields = changedFields.add("actionWebUrl");
            return this;
        }

        public Builder potentialScoreImpact(Double potentialScoreImpact) {
            this.potentialScoreImpact = potentialScoreImpact;
            this.changedFields = changedFields.add("potentialScoreImpact");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public RecommendedAction build() {
            RecommendedAction _x = new RecommendedAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recommendedAction";
            _x.actionWebUrl = actionWebUrl;
            _x.potentialScoreImpact = potentialScoreImpact;
            _x.title = title;
            return _x;
        }
    }

    private RecommendedAction _copy() {
        RecommendedAction _x = new RecommendedAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionWebUrl = actionWebUrl;
        _x.potentialScoreImpact = potentialScoreImpact;
        _x.title = title;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecommendedAction[");
        b.append("actionWebUrl=");
        b.append(this.actionWebUrl);
        b.append(", ");
        b.append("potentialScoreImpact=");
        b.append(this.potentialScoreImpact);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
