package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Proxied Domain”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ipAddressOrFQDN", 
    "proxy"})
@JsonInclude(Include.NON_NULL)
public class ProxiedDomain implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ipAddressOrFQDN")
    protected String ipAddressOrFQDN;

    @JsonProperty("proxy")
    protected String proxy;

    protected ProxiedDomain() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.proxiedDomain";
    }

    /**
     * <i>“The IP address or FQDN”</i>
     * 
     * @return property ipAddressOrFQDN
     */
    @Property(name="ipAddressOrFQDN")
    @JsonIgnore
    public Optional<String> getIpAddressOrFQDN() {
        return Optional.ofNullable(ipAddressOrFQDN);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipAddressOrFQDN}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The IP address or FQDN”</i>
     * 
     * @param ipAddressOrFQDN
     *            new value of {@code ipAddressOrFQDN} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipAddressOrFQDN} field changed
     */
    public ProxiedDomain withIpAddressOrFQDN(String ipAddressOrFQDN) {
        ProxiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.proxiedDomain");
        _x.ipAddressOrFQDN = ipAddressOrFQDN;
        return _x;
    }

    /**
     * <i>“Proxy IP or FQDN”</i>
     * 
     * @return property proxy
     */
    @Property(name="proxy")
    @JsonIgnore
    public Optional<String> getProxy() {
        return Optional.ofNullable(proxy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Proxy IP or FQDN”</i>
     * 
     * @param proxy
     *            new value of {@code proxy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxy} field changed
     */
    public ProxiedDomain withProxy(String proxy) {
        ProxiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.proxiedDomain");
        _x.proxy = proxy;
        return _x;
    }

    public ProxiedDomain withUnmappedField(String name, Object value) {
        ProxiedDomain _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ipAddressOrFQDN;
        private String proxy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The IP address or FQDN”</i>
         * 
         * @param ipAddressOrFQDN
         *            value of {@code ipAddressOrFQDN} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipAddressOrFQDN(String ipAddressOrFQDN) {
            this.ipAddressOrFQDN = ipAddressOrFQDN;
            this.changedFields = changedFields.add("ipAddressOrFQDN");
            return this;
        }

        /**
         * <i>“Proxy IP or FQDN”</i>
         * 
         * @param proxy
         *            value of {@code proxy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxy(String proxy) {
            this.proxy = proxy;
            this.changedFields = changedFields.add("proxy");
            return this;
        }

        public ProxiedDomain build() {
            ProxiedDomain _x = new ProxiedDomain();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.proxiedDomain";
            _x.ipAddressOrFQDN = ipAddressOrFQDN;
            _x.proxy = proxy;
            return _x;
        }
    }

    private ProxiedDomain _copy() {
        ProxiedDomain _x = new ProxiedDomain();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ipAddressOrFQDN = ipAddressOrFQDN;
        _x.proxy = proxy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProxiedDomain[");
        b.append("ipAddressOrFQDN=");
        b.append(this.ipAddressOrFQDN);
        b.append(", ");
        b.append("proxy=");
        b.append(this.proxy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
