package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ProvisioningResult;

@JsonPropertyOrder({
    "@odata.type", 
    "errorInformation", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ProvisioningStatusInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("errorInformation")
    protected ProvisioningErrorInfo errorInformation;

    @JsonProperty("status")
    protected ProvisioningResult status;

    protected ProvisioningStatusInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisioningStatusInfo";
    }

    @Property(name="errorInformation")
    @JsonIgnore
    public Optional<ProvisioningErrorInfo> getErrorInformation() {
        return Optional.ofNullable(errorInformation);
    }

    public ProvisioningStatusInfo withErrorInformation(ProvisioningErrorInfo errorInformation) {
        ProvisioningStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStatusInfo");
        _x.errorInformation = errorInformation;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ProvisioningResult> getStatus() {
        return Optional.ofNullable(status);
    }

    public ProvisioningStatusInfo withStatus(ProvisioningResult status) {
        ProvisioningStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStatusInfo");
        _x.status = status;
        return _x;
    }

    public ProvisioningStatusInfo withUnmappedField(String name, Object value) {
        ProvisioningStatusInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ProvisioningErrorInfo errorInformation;
        private ProvisioningResult status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder errorInformation(ProvisioningErrorInfo errorInformation) {
            this.errorInformation = errorInformation;
            this.changedFields = changedFields.add("errorInformation");
            return this;
        }

        public Builder status(ProvisioningResult status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ProvisioningStatusInfo build() {
            ProvisioningStatusInfo _x = new ProvisioningStatusInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.provisioningStatusInfo";
            _x.errorInformation = errorInformation;
            _x.status = status;
            return _x;
        }
    }

    private ProvisioningStatusInfo _copy() {
        ProvisioningStatusInfo _x = new ProvisioningStatusInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.errorInformation = errorInformation;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisioningStatusInfo[");
        b.append("errorInformation=");
        b.append(this.errorInformation);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
