package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "capabilityStatus", 
    "provisioningStatus", 
    "service"})
@JsonInclude(Include.NON_NULL)
public class ProvisionedPlan implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("capabilityStatus")
    protected String capabilityStatus;

    @JsonProperty("provisioningStatus")
    protected String provisioningStatus;

    @JsonProperty("service")
    protected String service;

    protected ProvisionedPlan() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisionedPlan";
    }

    @Property(name="capabilityStatus")
    @JsonIgnore
    public Optional<String> getCapabilityStatus() {
        return Optional.ofNullable(capabilityStatus);
    }

    public ProvisionedPlan withCapabilityStatus(String capabilityStatus) {
        ProvisionedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisionedPlan");
        _x.capabilityStatus = capabilityStatus;
        return _x;
    }

    @Property(name="provisioningStatus")
    @JsonIgnore
    public Optional<String> getProvisioningStatus() {
        return Optional.ofNullable(provisioningStatus);
    }

    public ProvisionedPlan withProvisioningStatus(String provisioningStatus) {
        ProvisionedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisionedPlan");
        _x.provisioningStatus = provisioningStatus;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public ProvisionedPlan withService(String service) {
        ProvisionedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisionedPlan");
        _x.service = service;
        return _x;
    }

    public ProvisionedPlan withUnmappedField(String name, Object value) {
        ProvisionedPlan _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String capabilityStatus;
        private String provisioningStatus;
        private String service;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder capabilityStatus(String capabilityStatus) {
            this.capabilityStatus = capabilityStatus;
            this.changedFields = changedFields.add("capabilityStatus");
            return this;
        }

        public Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            this.changedFields = changedFields.add("provisioningStatus");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public ProvisionedPlan build() {
            ProvisionedPlan _x = new ProvisionedPlan();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.provisionedPlan";
            _x.capabilityStatus = capabilityStatus;
            _x.provisioningStatus = provisioningStatus;
            _x.service = service;
            return _x;
        }
    }

    private ProvisionedPlan _copy() {
        ProvisionedPlan _x = new ProvisionedPlan();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.capabilityStatus = capabilityStatus;
        _x.provisioningStatus = provisioningStatus;
        _x.service = service;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisionedPlan[");
        b.append("capabilityStatus=");
        b.append(this.capabilityStatus);
        b.append(", ");
        b.append("provisioningStatus=");
        b.append(this.provisioningStatus);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
