package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedJobCount", 
    "incompleteJobCount", 
    "printerDisplayName", 
    "printerId", 
    "printerManufacturer", 
    "printerModel"})
@JsonInclude(Include.NON_NULL)
public class PrinterUsageSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedJobCount")
    protected Integer completedJobCount;

    @JsonProperty("incompleteJobCount")
    protected Integer incompleteJobCount;

    @JsonProperty("printerDisplayName")
    protected String printerDisplayName;

    @JsonProperty("printerId")
    protected String printerId;

    @JsonProperty("printerManufacturer")
    protected String printerManufacturer;

    @JsonProperty("printerModel")
    protected String printerModel;

    protected PrinterUsageSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerUsageSummary";
    }

    @Property(name="completedJobCount")
    @JsonIgnore
    public Optional<Integer> getCompletedJobCount() {
        return Optional.ofNullable(completedJobCount);
    }

    public PrinterUsageSummary withCompletedJobCount(Integer completedJobCount) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.completedJobCount = completedJobCount;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Integer> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public PrinterUsageSummary withIncompleteJobCount(Integer incompleteJobCount) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Property(name="printerDisplayName")
    @JsonIgnore
    public Optional<String> getPrinterDisplayName() {
        return Optional.ofNullable(printerDisplayName);
    }

    public PrinterUsageSummary withPrinterDisplayName(String printerDisplayName) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.printerDisplayName = printerDisplayName;
        return _x;
    }

    @Property(name="printerId")
    @JsonIgnore
    public Optional<String> getPrinterId() {
        return Optional.ofNullable(printerId);
    }

    public PrinterUsageSummary withPrinterId(String printerId) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.printerId = printerId;
        return _x;
    }

    @Property(name="printerManufacturer")
    @JsonIgnore
    public Optional<String> getPrinterManufacturer() {
        return Optional.ofNullable(printerManufacturer);
    }

    public PrinterUsageSummary withPrinterManufacturer(String printerManufacturer) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.printerManufacturer = printerManufacturer;
        return _x;
    }

    @Property(name="printerModel")
    @JsonIgnore
    public Optional<String> getPrinterModel() {
        return Optional.ofNullable(printerModel);
    }

    public PrinterUsageSummary withPrinterModel(String printerModel) {
        PrinterUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerUsageSummary");
        _x.printerModel = printerModel;
        return _x;
    }

    public PrinterUsageSummary withUnmappedField(String name, Object value) {
        PrinterUsageSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer completedJobCount;
        private Integer incompleteJobCount;
        private String printerDisplayName;
        private String printerId;
        private String printerManufacturer;
        private String printerModel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder completedJobCount(Integer completedJobCount) {
            this.completedJobCount = completedJobCount;
            this.changedFields = changedFields.add("completedJobCount");
            return this;
        }

        public Builder incompleteJobCount(Integer incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public Builder printerDisplayName(String printerDisplayName) {
            this.printerDisplayName = printerDisplayName;
            this.changedFields = changedFields.add("printerDisplayName");
            return this;
        }

        public Builder printerId(String printerId) {
            this.printerId = printerId;
            this.changedFields = changedFields.add("printerId");
            return this;
        }

        public Builder printerManufacturer(String printerManufacturer) {
            this.printerManufacturer = printerManufacturer;
            this.changedFields = changedFields.add("printerManufacturer");
            return this;
        }

        public Builder printerModel(String printerModel) {
            this.printerModel = printerModel;
            this.changedFields = changedFields.add("printerModel");
            return this;
        }

        public PrinterUsageSummary build() {
            PrinterUsageSummary _x = new PrinterUsageSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerUsageSummary";
            _x.completedJobCount = completedJobCount;
            _x.incompleteJobCount = incompleteJobCount;
            _x.printerDisplayName = printerDisplayName;
            _x.printerId = printerId;
            _x.printerManufacturer = printerManufacturer;
            _x.printerModel = printerModel;
            return _x;
        }
    }

    private PrinterUsageSummary _copy() {
        PrinterUsageSummary _x = new PrinterUsageSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.completedJobCount = completedJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        _x.printerDisplayName = printerDisplayName;
        _x.printerId = printerId;
        _x.printerManufacturer = printerManufacturer;
        _x.printerModel = printerModel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterUsageSummary[");
        b.append("completedJobCount=");
        b.append(this.completedJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append(", ");
        b.append("printerDisplayName=");
        b.append(this.printerDisplayName);
        b.append(", ");
        b.append("printerId=");
        b.append(this.printerId);
        b.append(", ");
        b.append("printerManufacturer=");
        b.append(this.printerManufacturer);
        b.append(", ");
        b.append("printerModel=");
        b.append(this.printerModel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
