package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrinterProcessingState;
import odata.msgraph.client.beta.enums.PrinterProcessingStateDetail;
import odata.msgraph.client.beta.enums.PrinterProcessingStateReason;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "details", 
    "processingState", 
    "processingStateDescription", 
    "processingStateReasons", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class PrinterStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("details")
    protected List<PrinterProcessingStateDetail> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    @JsonProperty("processingState")
    protected PrinterProcessingState processingState;

    @JsonProperty("processingStateDescription")
    protected String processingStateDescription;

    @JsonProperty("processingStateReasons")
    protected List<PrinterProcessingStateReason> processingStateReasons;

    @JsonProperty("processingStateReasons@nextLink")
    protected String processingStateReasonsNextLink;

    @JsonProperty("state")
    protected PrinterProcessingState state;

    protected PrinterStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerStatus";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PrinterStatus withDescription(String description) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.description = description;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateDetail> getDetails() {
        return new CollectionPage<PrinterProcessingStateDetail>(contextPath, PrinterProcessingStateDetail.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateDetail> getDetails(HttpRequestOptions options) {
        return new CollectionPage<PrinterProcessingStateDetail>(contextPath, PrinterProcessingStateDetail.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="processingState")
    @JsonIgnore
    public Optional<PrinterProcessingState> getProcessingState() {
        return Optional.ofNullable(processingState);
    }

    public PrinterStatus withProcessingState(PrinterProcessingState processingState) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.processingState = processingState;
        return _x;
    }

    @Property(name="processingStateDescription")
    @JsonIgnore
    public Optional<String> getProcessingStateDescription() {
        return Optional.ofNullable(processingStateDescription);
    }

    public PrinterStatus withProcessingStateDescription(String processingStateDescription) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.processingStateDescription = processingStateDescription;
        return _x;
    }

    @Property(name="processingStateReasons")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateReason> getProcessingStateReasons() {
        return new CollectionPage<PrinterProcessingStateReason>(contextPath, PrinterProcessingStateReason.class, this.processingStateReasons, Optional.ofNullable(processingStateReasonsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="processingStateReasons")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateReason> getProcessingStateReasons(HttpRequestOptions options) {
        return new CollectionPage<PrinterProcessingStateReason>(contextPath, PrinterProcessingStateReason.class, this.processingStateReasons, Optional.ofNullable(processingStateReasonsNextLink), Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<PrinterProcessingState> getState() {
        return Optional.ofNullable(state);
    }

    public PrinterStatus withState(PrinterProcessingState state) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.state = state;
        return _x;
    }

    public PrinterStatus withUnmappedField(String name, Object value) {
        PrinterStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private List<PrinterProcessingStateDetail> details;
        private String detailsNextLink;
        private PrinterProcessingState processingState;
        private String processingStateDescription;
        private List<PrinterProcessingStateReason> processingStateReasons;
        private String processingStateReasonsNextLink;
        private PrinterProcessingState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder details(List<PrinterProcessingStateDetail> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(PrinterProcessingStateDetail... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder processingState(PrinterProcessingState processingState) {
            this.processingState = processingState;
            this.changedFields = changedFields.add("processingState");
            return this;
        }

        public Builder processingStateDescription(String processingStateDescription) {
            this.processingStateDescription = processingStateDescription;
            this.changedFields = changedFields.add("processingStateDescription");
            return this;
        }

        public Builder processingStateReasons(List<PrinterProcessingStateReason> processingStateReasons) {
            this.processingStateReasons = processingStateReasons;
            this.changedFields = changedFields.add("processingStateReasons");
            return this;
        }

        public Builder processingStateReasons(PrinterProcessingStateReason... processingStateReasons) {
            return processingStateReasons(Arrays.asList(processingStateReasons));
        }

        public Builder processingStateReasonsNextLink(String processingStateReasonsNextLink) {
            this.processingStateReasonsNextLink = processingStateReasonsNextLink;
            this.changedFields = changedFields.add("processingStateReasons");
            return this;
        }

        public Builder state(PrinterProcessingState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public PrinterStatus build() {
            PrinterStatus _x = new PrinterStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerStatus";
            _x.description = description;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            _x.processingState = processingState;
            _x.processingStateDescription = processingStateDescription;
            _x.processingStateReasons = processingStateReasons;
            _x.processingStateReasonsNextLink = processingStateReasonsNextLink;
            _x.state = state;
            return _x;
        }
    }

    private PrinterStatus _copy() {
        PrinterStatus _x = new PrinterStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.details = details;
        _x.processingState = processingState;
        _x.processingStateDescription = processingStateDescription;
        _x.processingStateReasons = processingStateReasons;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterStatus[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("processingState=");
        b.append(this.processingState);
        b.append(", ");
        b.append("processingStateDescription=");
        b.append(this.processingStateDescription);
        b.append(", ");
        b.append("processingStateReasons=");
        b.append(this.processingStateReasons);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
