package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "bottom", 
    "left", 
    "right", 
    "top"})
@JsonInclude(Include.NON_NULL)
public class PrintMargin implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bottom")
    protected Integer bottom;

    @JsonProperty("left")
    protected Integer left;

    @JsonProperty("right")
    protected Integer right;

    @JsonProperty("top")
    protected Integer top;

    protected PrintMargin() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printMargin";
    }

    @Property(name="bottom")
    @JsonIgnore
    public Optional<Integer> getBottom() {
        return Optional.ofNullable(bottom);
    }

    public PrintMargin withBottom(Integer bottom) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.bottom = bottom;
        return _x;
    }

    @Property(name="left")
    @JsonIgnore
    public Optional<Integer> getLeft() {
        return Optional.ofNullable(left);
    }

    public PrintMargin withLeft(Integer left) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.left = left;
        return _x;
    }

    @Property(name="right")
    @JsonIgnore
    public Optional<Integer> getRight() {
        return Optional.ofNullable(right);
    }

    public PrintMargin withRight(Integer right) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.right = right;
        return _x;
    }

    @Property(name="top")
    @JsonIgnore
    public Optional<Integer> getTop() {
        return Optional.ofNullable(top);
    }

    public PrintMargin withTop(Integer top) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.top = top;
        return _x;
    }

    public PrintMargin withUnmappedField(String name, Object value) {
        PrintMargin _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer bottom;
        private Integer left;
        private Integer right;
        private Integer top;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder bottom(Integer bottom) {
            this.bottom = bottom;
            this.changedFields = changedFields.add("bottom");
            return this;
        }

        public Builder left(Integer left) {
            this.left = left;
            this.changedFields = changedFields.add("left");
            return this;
        }

        public Builder right(Integer right) {
            this.right = right;
            this.changedFields = changedFields.add("right");
            return this;
        }

        public Builder top(Integer top) {
            this.top = top;
            this.changedFields = changedFields.add("top");
            return this;
        }

        public PrintMargin build() {
            PrintMargin _x = new PrintMargin();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printMargin";
            _x.bottom = bottom;
            _x.left = left;
            _x.right = right;
            _x.top = top;
            return _x;
        }
    }

    private PrintMargin _copy() {
        PrintMargin _x = new PrintMargin();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bottom = bottom;
        _x.left = left;
        _x.right = right;
        _x.top = top;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintMargin[");
        b.append("bottom=");
        b.append(this.bottom);
        b.append(", ");
        b.append("left=");
        b.append(this.left);
        b.append(", ");
        b.append("right=");
        b.append(this.right);
        b.append(", ");
        b.append("top=");
        b.append(this.top);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
