package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintJobProcessingState;
import odata.msgraph.client.beta.enums.PrintJobStateDetail;

@JsonPropertyOrder({
    "@odata.type", 
    "acquiredByPrinter", 
    "description", 
    "details", 
    "isAcquiredByPrinter", 
    "processingState", 
    "processingStateDescription", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class PrintJobStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("acquiredByPrinter")
    protected Boolean acquiredByPrinter;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("details")
    protected List<PrintJobStateDetail> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    @JsonProperty("isAcquiredByPrinter")
    protected Boolean isAcquiredByPrinter;

    @JsonProperty("processingState")
    protected PrintJobProcessingState processingState;

    @JsonProperty("processingStateDescription")
    protected String processingStateDescription;

    @JsonProperty("state")
    protected PrintJobProcessingState state;

    protected PrintJobStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printJobStatus";
    }

    @Property(name="acquiredByPrinter")
    @JsonIgnore
    public Optional<Boolean> getAcquiredByPrinter() {
        return Optional.ofNullable(acquiredByPrinter);
    }

    public PrintJobStatus withAcquiredByPrinter(Boolean acquiredByPrinter) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.acquiredByPrinter = acquiredByPrinter;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PrintJobStatus withDescription(String description) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.description = description;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PrintJobStateDetail> getDetails() {
        return new CollectionPage<PrintJobStateDetail>(contextPath, PrintJobStateDetail.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PrintJobStateDetail> getDetails(HttpRequestOptions options) {
        return new CollectionPage<PrintJobStateDetail>(contextPath, PrintJobStateDetail.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isAcquiredByPrinter")
    @JsonIgnore
    public Optional<Boolean> getIsAcquiredByPrinter() {
        return Optional.ofNullable(isAcquiredByPrinter);
    }

    public PrintJobStatus withIsAcquiredByPrinter(Boolean isAcquiredByPrinter) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.isAcquiredByPrinter = isAcquiredByPrinter;
        return _x;
    }

    @Property(name="processingState")
    @JsonIgnore
    public Optional<PrintJobProcessingState> getProcessingState() {
        return Optional.ofNullable(processingState);
    }

    public PrintJobStatus withProcessingState(PrintJobProcessingState processingState) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.processingState = processingState;
        return _x;
    }

    @Property(name="processingStateDescription")
    @JsonIgnore
    public Optional<String> getProcessingStateDescription() {
        return Optional.ofNullable(processingStateDescription);
    }

    public PrintJobStatus withProcessingStateDescription(String processingStateDescription) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.processingStateDescription = processingStateDescription;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<PrintJobProcessingState> getState() {
        return Optional.ofNullable(state);
    }

    public PrintJobStatus withState(PrintJobProcessingState state) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.state = state;
        return _x;
    }

    public PrintJobStatus withUnmappedField(String name, Object value) {
        PrintJobStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean acquiredByPrinter;
        private String description;
        private List<PrintJobStateDetail> details;
        private String detailsNextLink;
        private Boolean isAcquiredByPrinter;
        private PrintJobProcessingState processingState;
        private String processingStateDescription;
        private PrintJobProcessingState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder acquiredByPrinter(Boolean acquiredByPrinter) {
            this.acquiredByPrinter = acquiredByPrinter;
            this.changedFields = changedFields.add("acquiredByPrinter");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder details(List<PrintJobStateDetail> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(PrintJobStateDetail... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder isAcquiredByPrinter(Boolean isAcquiredByPrinter) {
            this.isAcquiredByPrinter = isAcquiredByPrinter;
            this.changedFields = changedFields.add("isAcquiredByPrinter");
            return this;
        }

        public Builder processingState(PrintJobProcessingState processingState) {
            this.processingState = processingState;
            this.changedFields = changedFields.add("processingState");
            return this;
        }

        public Builder processingStateDescription(String processingStateDescription) {
            this.processingStateDescription = processingStateDescription;
            this.changedFields = changedFields.add("processingStateDescription");
            return this;
        }

        public Builder state(PrintJobProcessingState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public PrintJobStatus build() {
            PrintJobStatus _x = new PrintJobStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printJobStatus";
            _x.acquiredByPrinter = acquiredByPrinter;
            _x.description = description;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            _x.isAcquiredByPrinter = isAcquiredByPrinter;
            _x.processingState = processingState;
            _x.processingStateDescription = processingStateDescription;
            _x.state = state;
            return _x;
        }
    }

    private PrintJobStatus _copy() {
        PrintJobStatus _x = new PrintJobStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.acquiredByPrinter = acquiredByPrinter;
        _x.description = description;
        _x.details = details;
        _x.isAcquiredByPrinter = isAcquiredByPrinter;
        _x.processingState = processingState;
        _x.processingStateDescription = processingStateDescription;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintJobStatus[");
        b.append("acquiredByPrinter=");
        b.append(this.acquiredByPrinter);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("isAcquiredByPrinter=");
        b.append(this.isAcquiredByPrinter);
        b.append(", ");
        b.append("processingState=");
        b.append(this.processingState);
        b.append(", ");
        b.append("processingStateDescription=");
        b.append(this.processingStateDescription);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
