package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintColorMode;
import odata.msgraph.client.beta.enums.PrintDuplexMode;
import odata.msgraph.client.beta.enums.PrintFinishing;
import odata.msgraph.client.beta.enums.PrintMultipageLayout;
import odata.msgraph.client.beta.enums.PrintOrientation;
import odata.msgraph.client.beta.enums.PrintQuality;
import odata.msgraph.client.beta.enums.PrintScaling;
import odata.msgraph.client.beta.enums.PrinterFeedOrientation;

@JsonPropertyOrder({
    "@odata.type", 
    "collate", 
    "colorMode", 
    "copies", 
    "dpi", 
    "duplexMode", 
    "feedOrientation", 
    "finishings", 
    "fitPdfToPage", 
    "inputBin", 
    "margin", 
    "mediaSize", 
    "mediaType", 
    "multipageLayout", 
    "orientation", 
    "outputBin", 
    "pageRanges", 
    "pagesPerSheet", 
    "quality", 
    "scaling"})
@JsonInclude(Include.NON_NULL)
public class PrintJobConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("collate")
    protected Boolean collate;

    @JsonProperty("colorMode")
    protected PrintColorMode colorMode;

    @JsonProperty("copies")
    protected Integer copies;

    @JsonProperty("dpi")
    protected Integer dpi;

    @JsonProperty("duplexMode")
    protected PrintDuplexMode duplexMode;

    @JsonProperty("feedOrientation")
    protected PrinterFeedOrientation feedOrientation;

    @JsonProperty("finishings")
    protected List<PrintFinishing> finishings;

    @JsonProperty("finishings@nextLink")
    protected String finishingsNextLink;

    @JsonProperty("fitPdfToPage")
    protected Boolean fitPdfToPage;

    @JsonProperty("inputBin")
    protected String inputBin;

    @JsonProperty("margin")
    protected PrintMargin margin;

    @JsonProperty("mediaSize")
    protected String mediaSize;

    @JsonProperty("mediaType")
    protected String mediaType;

    @JsonProperty("multipageLayout")
    protected PrintMultipageLayout multipageLayout;

    @JsonProperty("orientation")
    protected PrintOrientation orientation;

    @JsonProperty("outputBin")
    protected String outputBin;

    @JsonProperty("pageRanges")
    protected List<IntegerRange> pageRanges;

    @JsonProperty("pageRanges@nextLink")
    protected String pageRangesNextLink;

    @JsonProperty("pagesPerSheet")
    protected Integer pagesPerSheet;

    @JsonProperty("quality")
    protected PrintQuality quality;

    @JsonProperty("scaling")
    protected PrintScaling scaling;

    protected PrintJobConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printJobConfiguration";
    }

    @Property(name="collate")
    @JsonIgnore
    public Optional<Boolean> getCollate() {
        return Optional.ofNullable(collate);
    }

    public PrintJobConfiguration withCollate(Boolean collate) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.collate = collate;
        return _x;
    }

    @Property(name="colorMode")
    @JsonIgnore
    public Optional<PrintColorMode> getColorMode() {
        return Optional.ofNullable(colorMode);
    }

    public PrintJobConfiguration withColorMode(PrintColorMode colorMode) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.colorMode = colorMode;
        return _x;
    }

    @Property(name="copies")
    @JsonIgnore
    public Optional<Integer> getCopies() {
        return Optional.ofNullable(copies);
    }

    public PrintJobConfiguration withCopies(Integer copies) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.copies = copies;
        return _x;
    }

    @Property(name="dpi")
    @JsonIgnore
    public Optional<Integer> getDpi() {
        return Optional.ofNullable(dpi);
    }

    public PrintJobConfiguration withDpi(Integer dpi) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.dpi = dpi;
        return _x;
    }

    @Property(name="duplexMode")
    @JsonIgnore
    public Optional<PrintDuplexMode> getDuplexMode() {
        return Optional.ofNullable(duplexMode);
    }

    public PrintJobConfiguration withDuplexMode(PrintDuplexMode duplexMode) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.duplexMode = duplexMode;
        return _x;
    }

    @Property(name="feedOrientation")
    @JsonIgnore
    public Optional<PrinterFeedOrientation> getFeedOrientation() {
        return Optional.ofNullable(feedOrientation);
    }

    public PrintJobConfiguration withFeedOrientation(PrinterFeedOrientation feedOrientation) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.feedOrientation = feedOrientation;
        return _x;
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings() {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings(HttpRequestOptions options) {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="fitPdfToPage")
    @JsonIgnore
    public Optional<Boolean> getFitPdfToPage() {
        return Optional.ofNullable(fitPdfToPage);
    }

    public PrintJobConfiguration withFitPdfToPage(Boolean fitPdfToPage) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.fitPdfToPage = fitPdfToPage;
        return _x;
    }

    @Property(name="inputBin")
    @JsonIgnore
    public Optional<String> getInputBin() {
        return Optional.ofNullable(inputBin);
    }

    public PrintJobConfiguration withInputBin(String inputBin) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.inputBin = inputBin;
        return _x;
    }

    @Property(name="margin")
    @JsonIgnore
    public Optional<PrintMargin> getMargin() {
        return Optional.ofNullable(margin);
    }

    public PrintJobConfiguration withMargin(PrintMargin margin) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.margin = margin;
        return _x;
    }

    @Property(name="mediaSize")
    @JsonIgnore
    public Optional<String> getMediaSize() {
        return Optional.ofNullable(mediaSize);
    }

    public PrintJobConfiguration withMediaSize(String mediaSize) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.mediaSize = mediaSize;
        return _x;
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<String> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public PrintJobConfiguration withMediaType(String mediaType) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="multipageLayout")
    @JsonIgnore
    public Optional<PrintMultipageLayout> getMultipageLayout() {
        return Optional.ofNullable(multipageLayout);
    }

    public PrintJobConfiguration withMultipageLayout(PrintMultipageLayout multipageLayout) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.multipageLayout = multipageLayout;
        return _x;
    }

    @Property(name="orientation")
    @JsonIgnore
    public Optional<PrintOrientation> getOrientation() {
        return Optional.ofNullable(orientation);
    }

    public PrintJobConfiguration withOrientation(PrintOrientation orientation) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.orientation = orientation;
        return _x;
    }

    @Property(name="outputBin")
    @JsonIgnore
    public Optional<String> getOutputBin() {
        return Optional.ofNullable(outputBin);
    }

    public PrintJobConfiguration withOutputBin(String outputBin) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.outputBin = outputBin;
        return _x;
    }

    @Property(name="pageRanges")
    @JsonIgnore
    public CollectionPage<IntegerRange> getPageRanges() {
        return new CollectionPage<IntegerRange>(contextPath, IntegerRange.class, this.pageRanges, Optional.ofNullable(pageRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pageRanges")
    @JsonIgnore
    public CollectionPage<IntegerRange> getPageRanges(HttpRequestOptions options) {
        return new CollectionPage<IntegerRange>(contextPath, IntegerRange.class, this.pageRanges, Optional.ofNullable(pageRangesNextLink), Collections.emptyList(), options);
    }

    @Property(name="pagesPerSheet")
    @JsonIgnore
    public Optional<Integer> getPagesPerSheet() {
        return Optional.ofNullable(pagesPerSheet);
    }

    public PrintJobConfiguration withPagesPerSheet(Integer pagesPerSheet) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.pagesPerSheet = pagesPerSheet;
        return _x;
    }

    @Property(name="quality")
    @JsonIgnore
    public Optional<PrintQuality> getQuality() {
        return Optional.ofNullable(quality);
    }

    public PrintJobConfiguration withQuality(PrintQuality quality) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.quality = quality;
        return _x;
    }

    @Property(name="scaling")
    @JsonIgnore
    public Optional<PrintScaling> getScaling() {
        return Optional.ofNullable(scaling);
    }

    public PrintJobConfiguration withScaling(PrintScaling scaling) {
        PrintJobConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobConfiguration");
        _x.scaling = scaling;
        return _x;
    }

    public PrintJobConfiguration withUnmappedField(String name, Object value) {
        PrintJobConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean collate;
        private PrintColorMode colorMode;
        private Integer copies;
        private Integer dpi;
        private PrintDuplexMode duplexMode;
        private PrinterFeedOrientation feedOrientation;
        private List<PrintFinishing> finishings;
        private String finishingsNextLink;
        private Boolean fitPdfToPage;
        private String inputBin;
        private PrintMargin margin;
        private String mediaSize;
        private String mediaType;
        private PrintMultipageLayout multipageLayout;
        private PrintOrientation orientation;
        private String outputBin;
        private List<IntegerRange> pageRanges;
        private String pageRangesNextLink;
        private Integer pagesPerSheet;
        private PrintQuality quality;
        private PrintScaling scaling;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder collate(Boolean collate) {
            this.collate = collate;
            this.changedFields = changedFields.add("collate");
            return this;
        }

        public Builder colorMode(PrintColorMode colorMode) {
            this.colorMode = colorMode;
            this.changedFields = changedFields.add("colorMode");
            return this;
        }

        public Builder copies(Integer copies) {
            this.copies = copies;
            this.changedFields = changedFields.add("copies");
            return this;
        }

        public Builder dpi(Integer dpi) {
            this.dpi = dpi;
            this.changedFields = changedFields.add("dpi");
            return this;
        }

        public Builder duplexMode(PrintDuplexMode duplexMode) {
            this.duplexMode = duplexMode;
            this.changedFields = changedFields.add("duplexMode");
            return this;
        }

        public Builder feedOrientation(PrinterFeedOrientation feedOrientation) {
            this.feedOrientation = feedOrientation;
            this.changedFields = changedFields.add("feedOrientation");
            return this;
        }

        public Builder finishings(List<PrintFinishing> finishings) {
            this.finishings = finishings;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder finishings(PrintFinishing... finishings) {
            return finishings(Arrays.asList(finishings));
        }

        public Builder finishingsNextLink(String finishingsNextLink) {
            this.finishingsNextLink = finishingsNextLink;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder fitPdfToPage(Boolean fitPdfToPage) {
            this.fitPdfToPage = fitPdfToPage;
            this.changedFields = changedFields.add("fitPdfToPage");
            return this;
        }

        public Builder inputBin(String inputBin) {
            this.inputBin = inputBin;
            this.changedFields = changedFields.add("inputBin");
            return this;
        }

        public Builder margin(PrintMargin margin) {
            this.margin = margin;
            this.changedFields = changedFields.add("margin");
            return this;
        }

        public Builder mediaSize(String mediaSize) {
            this.mediaSize = mediaSize;
            this.changedFields = changedFields.add("mediaSize");
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder multipageLayout(PrintMultipageLayout multipageLayout) {
            this.multipageLayout = multipageLayout;
            this.changedFields = changedFields.add("multipageLayout");
            return this;
        }

        public Builder orientation(PrintOrientation orientation) {
            this.orientation = orientation;
            this.changedFields = changedFields.add("orientation");
            return this;
        }

        public Builder outputBin(String outputBin) {
            this.outputBin = outputBin;
            this.changedFields = changedFields.add("outputBin");
            return this;
        }

        public Builder pageRanges(List<IntegerRange> pageRanges) {
            this.pageRanges = pageRanges;
            this.changedFields = changedFields.add("pageRanges");
            return this;
        }

        public Builder pageRanges(IntegerRange... pageRanges) {
            return pageRanges(Arrays.asList(pageRanges));
        }

        public Builder pageRangesNextLink(String pageRangesNextLink) {
            this.pageRangesNextLink = pageRangesNextLink;
            this.changedFields = changedFields.add("pageRanges");
            return this;
        }

        public Builder pagesPerSheet(Integer pagesPerSheet) {
            this.pagesPerSheet = pagesPerSheet;
            this.changedFields = changedFields.add("pagesPerSheet");
            return this;
        }

        public Builder quality(PrintQuality quality) {
            this.quality = quality;
            this.changedFields = changedFields.add("quality");
            return this;
        }

        public Builder scaling(PrintScaling scaling) {
            this.scaling = scaling;
            this.changedFields = changedFields.add("scaling");
            return this;
        }

        public PrintJobConfiguration build() {
            PrintJobConfiguration _x = new PrintJobConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printJobConfiguration";
            _x.collate = collate;
            _x.colorMode = colorMode;
            _x.copies = copies;
            _x.dpi = dpi;
            _x.duplexMode = duplexMode;
            _x.feedOrientation = feedOrientation;
            _x.finishings = finishings;
            _x.finishingsNextLink = finishingsNextLink;
            _x.fitPdfToPage = fitPdfToPage;
            _x.inputBin = inputBin;
            _x.margin = margin;
            _x.mediaSize = mediaSize;
            _x.mediaType = mediaType;
            _x.multipageLayout = multipageLayout;
            _x.orientation = orientation;
            _x.outputBin = outputBin;
            _x.pageRanges = pageRanges;
            _x.pageRangesNextLink = pageRangesNextLink;
            _x.pagesPerSheet = pagesPerSheet;
            _x.quality = quality;
            _x.scaling = scaling;
            return _x;
        }
    }

    private PrintJobConfiguration _copy() {
        PrintJobConfiguration _x = new PrintJobConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.collate = collate;
        _x.colorMode = colorMode;
        _x.copies = copies;
        _x.dpi = dpi;
        _x.duplexMode = duplexMode;
        _x.feedOrientation = feedOrientation;
        _x.finishings = finishings;
        _x.fitPdfToPage = fitPdfToPage;
        _x.inputBin = inputBin;
        _x.margin = margin;
        _x.mediaSize = mediaSize;
        _x.mediaType = mediaType;
        _x.multipageLayout = multipageLayout;
        _x.orientation = orientation;
        _x.outputBin = outputBin;
        _x.pageRanges = pageRanges;
        _x.pagesPerSheet = pagesPerSheet;
        _x.quality = quality;
        _x.scaling = scaling;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintJobConfiguration[");
        b.append("collate=");
        b.append(this.collate);
        b.append(", ");
        b.append("colorMode=");
        b.append(this.colorMode);
        b.append(", ");
        b.append("copies=");
        b.append(this.copies);
        b.append(", ");
        b.append("dpi=");
        b.append(this.dpi);
        b.append(", ");
        b.append("duplexMode=");
        b.append(this.duplexMode);
        b.append(", ");
        b.append("feedOrientation=");
        b.append(this.feedOrientation);
        b.append(", ");
        b.append("finishings=");
        b.append(this.finishings);
        b.append(", ");
        b.append("fitPdfToPage=");
        b.append(this.fitPdfToPage);
        b.append(", ");
        b.append("inputBin=");
        b.append(this.inputBin);
        b.append(", ");
        b.append("margin=");
        b.append(this.margin);
        b.append(", ");
        b.append("mediaSize=");
        b.append(this.mediaSize);
        b.append(", ");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("multipageLayout=");
        b.append(this.multipageLayout);
        b.append(", ");
        b.append("orientation=");
        b.append(this.orientation);
        b.append(", ");
        b.append("outputBin=");
        b.append(this.outputBin);
        b.append(", ");
        b.append("pageRanges=");
        b.append(this.pageRanges);
        b.append(", ");
        b.append("pagesPerSheet=");
        b.append(this.pagesPerSheet);
        b.append(", ");
        b.append("quality=");
        b.append(this.quality);
        b.append(", ");
        b.append("scaling=");
        b.append(this.scaling);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
