package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contentType", 
    "documentName", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class PrintDocumentUploadProperties implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("documentName")
    protected String documentName;

    @JsonProperty("size")
    protected Long size;

    protected PrintDocumentUploadProperties() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printDocumentUploadProperties";
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public PrintDocumentUploadProperties withContentType(String contentType) {
        PrintDocumentUploadProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocumentUploadProperties");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="documentName")
    @JsonIgnore
    public Optional<String> getDocumentName() {
        return Optional.ofNullable(documentName);
    }

    public PrintDocumentUploadProperties withDocumentName(String documentName) {
        PrintDocumentUploadProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocumentUploadProperties");
        _x.documentName = documentName;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public PrintDocumentUploadProperties withSize(Long size) {
        PrintDocumentUploadProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocumentUploadProperties");
        _x.size = size;
        return _x;
    }

    public PrintDocumentUploadProperties withUnmappedField(String name, Object value) {
        PrintDocumentUploadProperties _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String contentType;
        private String documentName;
        private Long size;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder documentName(String documentName) {
            this.documentName = documentName;
            this.changedFields = changedFields.add("documentName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public PrintDocumentUploadProperties build() {
            PrintDocumentUploadProperties _x = new PrintDocumentUploadProperties();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printDocumentUploadProperties";
            _x.contentType = contentType;
            _x.documentName = documentName;
            _x.size = size;
            return _x;
        }
    }

    private PrintDocumentUploadProperties _copy() {
        PrintDocumentUploadProperties _x = new PrintDocumentUploadProperties();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentType = contentType;
        _x.documentName = documentName;
        _x.size = size;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintDocumentUploadProperties[");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("documentName=");
        b.append(this.documentName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
