package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PlannerContextState;
import odata.msgraph.client.beta.enums.PlannerPlanContextType;

@JsonPropertyOrder({
    "@odata.type", 
    "customLinkText", 
    "displayLinkType", 
    "state", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class PlannerPlanContextDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("customLinkText")
    protected String customLinkText;

    @JsonProperty("displayLinkType")
    protected PlannerPlanContextType displayLinkType;

    @JsonProperty("state")
    protected PlannerContextState state;

    @JsonProperty("url")
    protected String url;

    protected PlannerPlanContextDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerPlanContextDetails";
    }

    @Property(name="customLinkText")
    @JsonIgnore
    public Optional<String> getCustomLinkText() {
        return Optional.ofNullable(customLinkText);
    }

    public PlannerPlanContextDetails withCustomLinkText(String customLinkText) {
        PlannerPlanContextDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContextDetails");
        _x.customLinkText = customLinkText;
        return _x;
    }

    @Property(name="displayLinkType")
    @JsonIgnore
    public Optional<PlannerPlanContextType> getDisplayLinkType() {
        return Optional.ofNullable(displayLinkType);
    }

    public PlannerPlanContextDetails withDisplayLinkType(PlannerPlanContextType displayLinkType) {
        PlannerPlanContextDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContextDetails");
        _x.displayLinkType = displayLinkType;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<PlannerContextState> getState() {
        return Optional.ofNullable(state);
    }

    public PlannerPlanContextDetails withState(PlannerContextState state) {
        PlannerPlanContextDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContextDetails");
        _x.state = state;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public PlannerPlanContextDetails withUrl(String url) {
        PlannerPlanContextDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContextDetails");
        _x.url = url;
        return _x;
    }

    public PlannerPlanContextDetails withUnmappedField(String name, Object value) {
        PlannerPlanContextDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String customLinkText;
        private PlannerPlanContextType displayLinkType;
        private PlannerContextState state;
        private String url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customLinkText(String customLinkText) {
            this.customLinkText = customLinkText;
            this.changedFields = changedFields.add("customLinkText");
            return this;
        }

        public Builder displayLinkType(PlannerPlanContextType displayLinkType) {
            this.displayLinkType = displayLinkType;
            this.changedFields = changedFields.add("displayLinkType");
            return this;
        }

        public Builder state(PlannerContextState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public PlannerPlanContextDetails build() {
            PlannerPlanContextDetails _x = new PlannerPlanContextDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerPlanContextDetails";
            _x.customLinkText = customLinkText;
            _x.displayLinkType = displayLinkType;
            _x.state = state;
            _x.url = url;
            return _x;
        }
    }

    private PlannerPlanContextDetails _copy() {
        PlannerPlanContextDetails _x = new PlannerPlanContextDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customLinkText = customLinkText;
        _x.displayLinkType = displayLinkType;
        _x.state = state;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerPlanContextDetails[");
        b.append("customLinkText=");
        b.append(this.customLinkText);
        b.append(", ");
        b.append("displayLinkType=");
        b.append(this.displayLinkType);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
