package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "alias", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "previewPriority", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class PlannerExternalReference implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("alias")
    protected String alias;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("previewPriority")
    protected String previewPriority;

    @JsonProperty("type")
    protected String type;

    protected PlannerExternalReference() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerExternalReference";
    }

    @Property(name="alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    public PlannerExternalReference withAlias(String alias) {
        PlannerExternalReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerExternalReference");
        _x.alias = alias;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public PlannerExternalReference withLastModifiedBy(IdentitySet lastModifiedBy) {
        PlannerExternalReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerExternalReference");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public PlannerExternalReference withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PlannerExternalReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerExternalReference");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="previewPriority")
    @JsonIgnore
    public Optional<String> getPreviewPriority() {
        return Optional.ofNullable(previewPriority);
    }

    public PlannerExternalReference withPreviewPriority(String previewPriority) {
        PlannerExternalReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerExternalReference");
        _x.previewPriority = previewPriority;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public PlannerExternalReference withType(String type) {
        PlannerExternalReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerExternalReference");
        _x.type = type;
        return _x;
    }

    public PlannerExternalReference withUnmappedField(String name, Object value) {
        PlannerExternalReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String alias;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String previewPriority;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = changedFields.add("alias");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder previewPriority(String previewPriority) {
            this.previewPriority = previewPriority;
            this.changedFields = changedFields.add("previewPriority");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public PlannerExternalReference build() {
            PlannerExternalReference _x = new PlannerExternalReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerExternalReference";
            _x.alias = alias;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.previewPriority = previewPriority;
            _x.type = type;
            return _x;
        }
    }

    private PlannerExternalReference _copy() {
        PlannerExternalReference _x = new PlannerExternalReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.alias = alias;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.previewPriority = previewPriority;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerExternalReference[");
        b.append("alias=");
        b.append(this.alias);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("previewPriority=");
        b.append(this.previewPriority);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
