package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "category1", 
    "category10", 
    "category11", 
    "category12", 
    "category13", 
    "category14", 
    "category15", 
    "category16", 
    "category17", 
    "category18", 
    "category19", 
    "category2", 
    "category20", 
    "category21", 
    "category22", 
    "category23", 
    "category24", 
    "category25", 
    "category3", 
    "category4", 
    "category5", 
    "category6", 
    "category7", 
    "category8", 
    "category9"})
@JsonInclude(Include.NON_NULL)
public class PlannerCategoryDescriptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("category1")
    protected String category1;

    @JsonProperty("category10")
    protected String category10;

    @JsonProperty("category11")
    protected String category11;

    @JsonProperty("category12")
    protected String category12;

    @JsonProperty("category13")
    protected String category13;

    @JsonProperty("category14")
    protected String category14;

    @JsonProperty("category15")
    protected String category15;

    @JsonProperty("category16")
    protected String category16;

    @JsonProperty("category17")
    protected String category17;

    @JsonProperty("category18")
    protected String category18;

    @JsonProperty("category19")
    protected String category19;

    @JsonProperty("category2")
    protected String category2;

    @JsonProperty("category20")
    protected String category20;

    @JsonProperty("category21")
    protected String category21;

    @JsonProperty("category22")
    protected String category22;

    @JsonProperty("category23")
    protected String category23;

    @JsonProperty("category24")
    protected String category24;

    @JsonProperty("category25")
    protected String category25;

    @JsonProperty("category3")
    protected String category3;

    @JsonProperty("category4")
    protected String category4;

    @JsonProperty("category5")
    protected String category5;

    @JsonProperty("category6")
    protected String category6;

    @JsonProperty("category7")
    protected String category7;

    @JsonProperty("category8")
    protected String category8;

    @JsonProperty("category9")
    protected String category9;

    protected PlannerCategoryDescriptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerCategoryDescriptions";
    }

    @Property(name="category1")
    @JsonIgnore
    public Optional<String> getCategory1() {
        return Optional.ofNullable(category1);
    }

    public PlannerCategoryDescriptions withCategory1(String category1) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category1 = category1;
        return _x;
    }

    @Property(name="category10")
    @JsonIgnore
    public Optional<String> getCategory10() {
        return Optional.ofNullable(category10);
    }

    public PlannerCategoryDescriptions withCategory10(String category10) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category10 = category10;
        return _x;
    }

    @Property(name="category11")
    @JsonIgnore
    public Optional<String> getCategory11() {
        return Optional.ofNullable(category11);
    }

    public PlannerCategoryDescriptions withCategory11(String category11) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category11 = category11;
        return _x;
    }

    @Property(name="category12")
    @JsonIgnore
    public Optional<String> getCategory12() {
        return Optional.ofNullable(category12);
    }

    public PlannerCategoryDescriptions withCategory12(String category12) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category12 = category12;
        return _x;
    }

    @Property(name="category13")
    @JsonIgnore
    public Optional<String> getCategory13() {
        return Optional.ofNullable(category13);
    }

    public PlannerCategoryDescriptions withCategory13(String category13) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category13 = category13;
        return _x;
    }

    @Property(name="category14")
    @JsonIgnore
    public Optional<String> getCategory14() {
        return Optional.ofNullable(category14);
    }

    public PlannerCategoryDescriptions withCategory14(String category14) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category14 = category14;
        return _x;
    }

    @Property(name="category15")
    @JsonIgnore
    public Optional<String> getCategory15() {
        return Optional.ofNullable(category15);
    }

    public PlannerCategoryDescriptions withCategory15(String category15) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category15 = category15;
        return _x;
    }

    @Property(name="category16")
    @JsonIgnore
    public Optional<String> getCategory16() {
        return Optional.ofNullable(category16);
    }

    public PlannerCategoryDescriptions withCategory16(String category16) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category16 = category16;
        return _x;
    }

    @Property(name="category17")
    @JsonIgnore
    public Optional<String> getCategory17() {
        return Optional.ofNullable(category17);
    }

    public PlannerCategoryDescriptions withCategory17(String category17) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category17 = category17;
        return _x;
    }

    @Property(name="category18")
    @JsonIgnore
    public Optional<String> getCategory18() {
        return Optional.ofNullable(category18);
    }

    public PlannerCategoryDescriptions withCategory18(String category18) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category18 = category18;
        return _x;
    }

    @Property(name="category19")
    @JsonIgnore
    public Optional<String> getCategory19() {
        return Optional.ofNullable(category19);
    }

    public PlannerCategoryDescriptions withCategory19(String category19) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category19 = category19;
        return _x;
    }

    @Property(name="category2")
    @JsonIgnore
    public Optional<String> getCategory2() {
        return Optional.ofNullable(category2);
    }

    public PlannerCategoryDescriptions withCategory2(String category2) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category2 = category2;
        return _x;
    }

    @Property(name="category20")
    @JsonIgnore
    public Optional<String> getCategory20() {
        return Optional.ofNullable(category20);
    }

    public PlannerCategoryDescriptions withCategory20(String category20) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category20 = category20;
        return _x;
    }

    @Property(name="category21")
    @JsonIgnore
    public Optional<String> getCategory21() {
        return Optional.ofNullable(category21);
    }

    public PlannerCategoryDescriptions withCategory21(String category21) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category21 = category21;
        return _x;
    }

    @Property(name="category22")
    @JsonIgnore
    public Optional<String> getCategory22() {
        return Optional.ofNullable(category22);
    }

    public PlannerCategoryDescriptions withCategory22(String category22) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category22 = category22;
        return _x;
    }

    @Property(name="category23")
    @JsonIgnore
    public Optional<String> getCategory23() {
        return Optional.ofNullable(category23);
    }

    public PlannerCategoryDescriptions withCategory23(String category23) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category23 = category23;
        return _x;
    }

    @Property(name="category24")
    @JsonIgnore
    public Optional<String> getCategory24() {
        return Optional.ofNullable(category24);
    }

    public PlannerCategoryDescriptions withCategory24(String category24) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category24 = category24;
        return _x;
    }

    @Property(name="category25")
    @JsonIgnore
    public Optional<String> getCategory25() {
        return Optional.ofNullable(category25);
    }

    public PlannerCategoryDescriptions withCategory25(String category25) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category25 = category25;
        return _x;
    }

    @Property(name="category3")
    @JsonIgnore
    public Optional<String> getCategory3() {
        return Optional.ofNullable(category3);
    }

    public PlannerCategoryDescriptions withCategory3(String category3) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category3 = category3;
        return _x;
    }

    @Property(name="category4")
    @JsonIgnore
    public Optional<String> getCategory4() {
        return Optional.ofNullable(category4);
    }

    public PlannerCategoryDescriptions withCategory4(String category4) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category4 = category4;
        return _x;
    }

    @Property(name="category5")
    @JsonIgnore
    public Optional<String> getCategory5() {
        return Optional.ofNullable(category5);
    }

    public PlannerCategoryDescriptions withCategory5(String category5) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category5 = category5;
        return _x;
    }

    @Property(name="category6")
    @JsonIgnore
    public Optional<String> getCategory6() {
        return Optional.ofNullable(category6);
    }

    public PlannerCategoryDescriptions withCategory6(String category6) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category6 = category6;
        return _x;
    }

    @Property(name="category7")
    @JsonIgnore
    public Optional<String> getCategory7() {
        return Optional.ofNullable(category7);
    }

    public PlannerCategoryDescriptions withCategory7(String category7) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category7 = category7;
        return _x;
    }

    @Property(name="category8")
    @JsonIgnore
    public Optional<String> getCategory8() {
        return Optional.ofNullable(category8);
    }

    public PlannerCategoryDescriptions withCategory8(String category8) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category8 = category8;
        return _x;
    }

    @Property(name="category9")
    @JsonIgnore
    public Optional<String> getCategory9() {
        return Optional.ofNullable(category9);
    }

    public PlannerCategoryDescriptions withCategory9(String category9) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category9 = category9;
        return _x;
    }

    public PlannerCategoryDescriptions withUnmappedField(String name, Object value) {
        PlannerCategoryDescriptions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String category1;
        private String category10;
        private String category11;
        private String category12;
        private String category13;
        private String category14;
        private String category15;
        private String category16;
        private String category17;
        private String category18;
        private String category19;
        private String category2;
        private String category20;
        private String category21;
        private String category22;
        private String category23;
        private String category24;
        private String category25;
        private String category3;
        private String category4;
        private String category5;
        private String category6;
        private String category7;
        private String category8;
        private String category9;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder category1(String category1) {
            this.category1 = category1;
            this.changedFields = changedFields.add("category1");
            return this;
        }

        public Builder category10(String category10) {
            this.category10 = category10;
            this.changedFields = changedFields.add("category10");
            return this;
        }

        public Builder category11(String category11) {
            this.category11 = category11;
            this.changedFields = changedFields.add("category11");
            return this;
        }

        public Builder category12(String category12) {
            this.category12 = category12;
            this.changedFields = changedFields.add("category12");
            return this;
        }

        public Builder category13(String category13) {
            this.category13 = category13;
            this.changedFields = changedFields.add("category13");
            return this;
        }

        public Builder category14(String category14) {
            this.category14 = category14;
            this.changedFields = changedFields.add("category14");
            return this;
        }

        public Builder category15(String category15) {
            this.category15 = category15;
            this.changedFields = changedFields.add("category15");
            return this;
        }

        public Builder category16(String category16) {
            this.category16 = category16;
            this.changedFields = changedFields.add("category16");
            return this;
        }

        public Builder category17(String category17) {
            this.category17 = category17;
            this.changedFields = changedFields.add("category17");
            return this;
        }

        public Builder category18(String category18) {
            this.category18 = category18;
            this.changedFields = changedFields.add("category18");
            return this;
        }

        public Builder category19(String category19) {
            this.category19 = category19;
            this.changedFields = changedFields.add("category19");
            return this;
        }

        public Builder category2(String category2) {
            this.category2 = category2;
            this.changedFields = changedFields.add("category2");
            return this;
        }

        public Builder category20(String category20) {
            this.category20 = category20;
            this.changedFields = changedFields.add("category20");
            return this;
        }

        public Builder category21(String category21) {
            this.category21 = category21;
            this.changedFields = changedFields.add("category21");
            return this;
        }

        public Builder category22(String category22) {
            this.category22 = category22;
            this.changedFields = changedFields.add("category22");
            return this;
        }

        public Builder category23(String category23) {
            this.category23 = category23;
            this.changedFields = changedFields.add("category23");
            return this;
        }

        public Builder category24(String category24) {
            this.category24 = category24;
            this.changedFields = changedFields.add("category24");
            return this;
        }

        public Builder category25(String category25) {
            this.category25 = category25;
            this.changedFields = changedFields.add("category25");
            return this;
        }

        public Builder category3(String category3) {
            this.category3 = category3;
            this.changedFields = changedFields.add("category3");
            return this;
        }

        public Builder category4(String category4) {
            this.category4 = category4;
            this.changedFields = changedFields.add("category4");
            return this;
        }

        public Builder category5(String category5) {
            this.category5 = category5;
            this.changedFields = changedFields.add("category5");
            return this;
        }

        public Builder category6(String category6) {
            this.category6 = category6;
            this.changedFields = changedFields.add("category6");
            return this;
        }

        public Builder category7(String category7) {
            this.category7 = category7;
            this.changedFields = changedFields.add("category7");
            return this;
        }

        public Builder category8(String category8) {
            this.category8 = category8;
            this.changedFields = changedFields.add("category8");
            return this;
        }

        public Builder category9(String category9) {
            this.category9 = category9;
            this.changedFields = changedFields.add("category9");
            return this;
        }

        public PlannerCategoryDescriptions build() {
            PlannerCategoryDescriptions _x = new PlannerCategoryDescriptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerCategoryDescriptions";
            _x.category1 = category1;
            _x.category10 = category10;
            _x.category11 = category11;
            _x.category12 = category12;
            _x.category13 = category13;
            _x.category14 = category14;
            _x.category15 = category15;
            _x.category16 = category16;
            _x.category17 = category17;
            _x.category18 = category18;
            _x.category19 = category19;
            _x.category2 = category2;
            _x.category20 = category20;
            _x.category21 = category21;
            _x.category22 = category22;
            _x.category23 = category23;
            _x.category24 = category24;
            _x.category25 = category25;
            _x.category3 = category3;
            _x.category4 = category4;
            _x.category5 = category5;
            _x.category6 = category6;
            _x.category7 = category7;
            _x.category8 = category8;
            _x.category9 = category9;
            return _x;
        }
    }

    private PlannerCategoryDescriptions _copy() {
        PlannerCategoryDescriptions _x = new PlannerCategoryDescriptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.category1 = category1;
        _x.category10 = category10;
        _x.category11 = category11;
        _x.category12 = category12;
        _x.category13 = category13;
        _x.category14 = category14;
        _x.category15 = category15;
        _x.category16 = category16;
        _x.category17 = category17;
        _x.category18 = category18;
        _x.category19 = category19;
        _x.category2 = category2;
        _x.category20 = category20;
        _x.category21 = category21;
        _x.category22 = category22;
        _x.category23 = category23;
        _x.category24 = category24;
        _x.category25 = category25;
        _x.category3 = category3;
        _x.category4 = category4;
        _x.category5 = category5;
        _x.category6 = category6;
        _x.category7 = category7;
        _x.category8 = category8;
        _x.category9 = category9;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerCategoryDescriptions[");
        b.append("category1=");
        b.append(this.category1);
        b.append(", ");
        b.append("category10=");
        b.append(this.category10);
        b.append(", ");
        b.append("category11=");
        b.append(this.category11);
        b.append(", ");
        b.append("category12=");
        b.append(this.category12);
        b.append(", ");
        b.append("category13=");
        b.append(this.category13);
        b.append(", ");
        b.append("category14=");
        b.append(this.category14);
        b.append(", ");
        b.append("category15=");
        b.append(this.category15);
        b.append(", ");
        b.append("category16=");
        b.append(this.category16);
        b.append(", ");
        b.append("category17=");
        b.append(this.category17);
        b.append(", ");
        b.append("category18=");
        b.append(this.category18);
        b.append(", ");
        b.append("category19=");
        b.append(this.category19);
        b.append(", ");
        b.append("category2=");
        b.append(this.category2);
        b.append(", ");
        b.append("category20=");
        b.append(this.category20);
        b.append(", ");
        b.append("category21=");
        b.append(this.category21);
        b.append(", ");
        b.append("category22=");
        b.append(this.category22);
        b.append(", ");
        b.append("category23=");
        b.append(this.category23);
        b.append(", ");
        b.append("category24=");
        b.append(this.category24);
        b.append(", ");
        b.append("category25=");
        b.append(this.category25);
        b.append(", ");
        b.append("category3=");
        b.append(this.category3);
        b.append(", ");
        b.append("category4=");
        b.append(this.category4);
        b.append(", ");
        b.append("category5=");
        b.append(this.category5);
        b.append(", ");
        b.append("category6=");
        b.append(this.category6);
        b.append(", ");
        b.append("category7=");
        b.append(this.category7);
        b.append(", ");
        b.append("category8=");
        b.append(this.category8);
        b.append(", ");
        b.append("category9=");
        b.append(this.category9);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
