package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedBy", 
    "assignedDateTime", 
    "orderHint"})
@JsonInclude(Include.NON_NULL)
public class PlannerAssignment implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedBy")
    protected IdentitySet assignedBy;

    @JsonProperty("assignedDateTime")
    protected OffsetDateTime assignedDateTime;

    @JsonProperty("orderHint")
    protected String orderHint;

    protected PlannerAssignment() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerAssignment";
    }

    @Property(name="assignedBy")
    @JsonIgnore
    public Optional<IdentitySet> getAssignedBy() {
        return Optional.ofNullable(assignedBy);
    }

    public PlannerAssignment withAssignedBy(IdentitySet assignedBy) {
        PlannerAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerAssignment");
        _x.assignedBy = assignedBy;
        return _x;
    }

    @Property(name="assignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignedDateTime() {
        return Optional.ofNullable(assignedDateTime);
    }

    public PlannerAssignment withAssignedDateTime(OffsetDateTime assignedDateTime) {
        PlannerAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerAssignment");
        _x.assignedDateTime = assignedDateTime;
        return _x;
    }

    @Property(name="orderHint")
    @JsonIgnore
    public Optional<String> getOrderHint() {
        return Optional.ofNullable(orderHint);
    }

    public PlannerAssignment withOrderHint(String orderHint) {
        PlannerAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerAssignment");
        _x.orderHint = orderHint;
        return _x;
    }

    public PlannerAssignment withUnmappedField(String name, Object value) {
        PlannerAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet assignedBy;
        private OffsetDateTime assignedDateTime;
        private String orderHint;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedBy(IdentitySet assignedBy) {
            this.assignedBy = assignedBy;
            this.changedFields = changedFields.add("assignedBy");
            return this;
        }

        public Builder assignedDateTime(OffsetDateTime assignedDateTime) {
            this.assignedDateTime = assignedDateTime;
            this.changedFields = changedFields.add("assignedDateTime");
            return this;
        }

        public Builder orderHint(String orderHint) {
            this.orderHint = orderHint;
            this.changedFields = changedFields.add("orderHint");
            return this;
        }

        public PlannerAssignment build() {
            PlannerAssignment _x = new PlannerAssignment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerAssignment";
            _x.assignedBy = assignedBy;
            _x.assignedDateTime = assignedDateTime;
            _x.orderHint = orderHint;
            return _x;
        }
    }

    private PlannerAssignment _copy() {
        PlannerAssignment _x = new PlannerAssignment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedBy = assignedBy;
        _x.assignedDateTime = assignedDateTime;
        _x.orderHint = orderHint;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerAssignment[");
        b.append("assignedBy=");
        b.append(this.assignedBy);
        b.append(", ");
        b.append("assignedDateTime=");
        b.append(this.assignedDateTime);
        b.append(", ");
        b.append("orderHint=");
        b.append(this.orderHint);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
