package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "password", 
    "pkcs12Value"})
@JsonInclude(Include.NON_NULL)
public class Pkcs12Certificate extends ApiAuthenticationConfigurationBase implements ODataType {

    @JsonProperty("password")
    protected String password;

    @JsonProperty("pkcs12Value")
    protected String pkcs12Value;

    protected Pkcs12Certificate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.pkcs12Certificate";
    }

    @Property(name="password")
    @JsonIgnore
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    public Pkcs12Certificate withPassword(String password) {
        Pkcs12Certificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12Certificate");
        _x.password = password;
        return _x;
    }

    @Property(name="pkcs12Value")
    @JsonIgnore
    public Optional<String> getPkcs12Value() {
        return Optional.ofNullable(pkcs12Value);
    }

    public Pkcs12Certificate withPkcs12Value(String pkcs12Value) {
        Pkcs12Certificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12Certificate");
        _x.pkcs12Value = pkcs12Value;
        return _x;
    }

    public Pkcs12Certificate withUnmappedField(String name, Object value) {
        Pkcs12Certificate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPkcs12Certificate() {
        return new Builder();
    }

    public static final class Builder {
        private String password;
        private String pkcs12Value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder password(String password) {
            this.password = password;
            this.changedFields = changedFields.add("password");
            return this;
        }

        public Builder pkcs12Value(String pkcs12Value) {
            this.pkcs12Value = pkcs12Value;
            this.changedFields = changedFields.add("pkcs12Value");
            return this;
        }

        public Pkcs12Certificate build() {
            Pkcs12Certificate _x = new Pkcs12Certificate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.pkcs12Certificate";
            _x.password = password;
            _x.pkcs12Value = pkcs12Value;
            return _x;
        }
    }

    private Pkcs12Certificate _copy() {
        Pkcs12Certificate _x = new Pkcs12Certificate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.password = password;
        _x.pkcs12Value = pkcs12Value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Pkcs12Certificate[");
        b.append("password=");
        b.append(this.password);
        b.append(", ");
        b.append("pkcs12Value=");
        b.append(this.pkcs12Value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
