package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "first", 
    "last", 
    "maiden", 
    "middle"})
@JsonInclude(Include.NON_NULL)
public class PersonNamePronounciation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("first")
    protected String first;

    @JsonProperty("last")
    protected String last;

    @JsonProperty("maiden")
    protected String maiden;

    @JsonProperty("middle")
    protected String middle;

    protected PersonNamePronounciation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personNamePronounciation";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PersonNamePronounciation withDisplayName(String displayName) {
        PersonNamePronounciation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personNamePronounciation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="first")
    @JsonIgnore
    public Optional<String> getFirst() {
        return Optional.ofNullable(first);
    }

    public PersonNamePronounciation withFirst(String first) {
        PersonNamePronounciation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personNamePronounciation");
        _x.first = first;
        return _x;
    }

    @Property(name="last")
    @JsonIgnore
    public Optional<String> getLast() {
        return Optional.ofNullable(last);
    }

    public PersonNamePronounciation withLast(String last) {
        PersonNamePronounciation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personNamePronounciation");
        _x.last = last;
        return _x;
    }

    @Property(name="maiden")
    @JsonIgnore
    public Optional<String> getMaiden() {
        return Optional.ofNullable(maiden);
    }

    public PersonNamePronounciation withMaiden(String maiden) {
        PersonNamePronounciation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personNamePronounciation");
        _x.maiden = maiden;
        return _x;
    }

    @Property(name="middle")
    @JsonIgnore
    public Optional<String> getMiddle() {
        return Optional.ofNullable(middle);
    }

    public PersonNamePronounciation withMiddle(String middle) {
        PersonNamePronounciation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personNamePronounciation");
        _x.middle = middle;
        return _x;
    }

    public PersonNamePronounciation withUnmappedField(String name, Object value) {
        PersonNamePronounciation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String first;
        private String last;
        private String maiden;
        private String middle;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder first(String first) {
            this.first = first;
            this.changedFields = changedFields.add("first");
            return this;
        }

        public Builder last(String last) {
            this.last = last;
            this.changedFields = changedFields.add("last");
            return this;
        }

        public Builder maiden(String maiden) {
            this.maiden = maiden;
            this.changedFields = changedFields.add("maiden");
            return this;
        }

        public Builder middle(String middle) {
            this.middle = middle;
            this.changedFields = changedFields.add("middle");
            return this;
        }

        public PersonNamePronounciation build() {
            PersonNamePronounciation _x = new PersonNamePronounciation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.personNamePronounciation";
            _x.displayName = displayName;
            _x.first = first;
            _x.last = last;
            _x.maiden = maiden;
            _x.middle = middle;
            return _x;
        }
    }

    private PersonNamePronounciation _copy() {
        PersonNamePronounciation _x = new PersonNamePronounciation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.first = first;
        _x.last = last;
        _x.maiden = maiden;
        _x.middle = middle;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonNamePronounciation[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("first=");
        b.append(this.first);
        b.append(", ");
        b.append("last=");
        b.append(this.last);
        b.append(", ");
        b.append("maiden=");
        b.append(this.maiden);
        b.append(", ");
        b.append("middle=");
        b.append(this.middle);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
