package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class PersonDataSources implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected List<String> type;

    @JsonProperty("type@nextLink")
    protected String typeNextLink;

    protected PersonDataSources() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personDataSources";
    }

    @Property(name="type")
    @JsonIgnore
    public CollectionPage<String> getType() {
        return new CollectionPage<String>(contextPath, String.class, this.type, Optional.ofNullable(typeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="type")
    @JsonIgnore
    public CollectionPage<String> getType(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.type, Optional.ofNullable(typeNextLink), Collections.emptyList(), options);
    }

    public PersonDataSources withUnmappedField(String name, Object value) {
        PersonDataSources _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> type;
        private String typeNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder type(List<String> type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder type(String... type) {
            return type(Arrays.asList(type));
        }

        public Builder typeNextLink(String typeNextLink) {
            this.typeNextLink = typeNextLink;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public PersonDataSources build() {
            PersonDataSources _x = new PersonDataSources();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.personDataSources";
            _x.type = type;
            _x.typeNextLink = typeNextLink;
            return _x;
        }
    }

    private PersonDataSources _copy() {
        PersonDataSources _x = new PersonDataSources();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonDataSources[");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
