package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PersistentBrowserSessionMode;

@JsonPropertyOrder({
    "@odata.type", 
    "mode"})
@JsonInclude(Include.NON_NULL)
public class PersistentBrowserSessionControl extends ConditionalAccessSessionControl implements ODataType {

    @JsonProperty("mode")
    protected PersistentBrowserSessionMode mode;

    protected PersistentBrowserSessionControl() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.persistentBrowserSessionControl";
    }

    @Property(name="mode")
    @JsonIgnore
    public Optional<PersistentBrowserSessionMode> getMode() {
        return Optional.ofNullable(mode);
    }

    public PersistentBrowserSessionControl withMode(PersistentBrowserSessionMode mode) {
        PersistentBrowserSessionControl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.persistentBrowserSessionControl");
        _x.mode = mode;
        return _x;
    }

    public PersistentBrowserSessionControl withUnmappedField(String name, Object value) {
        PersistentBrowserSessionControl _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersistentBrowserSessionControl() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private PersistentBrowserSessionMode mode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder mode(PersistentBrowserSessionMode mode) {
            this.mode = mode;
            this.changedFields = changedFields.add("mode");
            return this;
        }

        public PersistentBrowserSessionControl build() {
            PersistentBrowserSessionControl _x = new PersistentBrowserSessionControl();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.persistentBrowserSessionControl";
            _x.isEnabled = isEnabled;
            _x.mode = mode;
            return _x;
        }
    }

    private PersistentBrowserSessionControl _copy() {
        PersistentBrowserSessionControl _x = new PersistentBrowserSessionControl();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.mode = mode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersistentBrowserSessionControl[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("mode=");
        b.append(this.mode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
