package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "pendingContentUpdate"})
@JsonInclude(Include.NON_NULL)
public class PendingOperations implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("pendingContentUpdate")
    protected PendingContentUpdate pendingContentUpdate;

    protected PendingOperations() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.pendingOperations";
    }

    @Property(name="pendingContentUpdate")
    @JsonIgnore
    public Optional<PendingContentUpdate> getPendingContentUpdate() {
        return Optional.ofNullable(pendingContentUpdate);
    }

    public PendingOperations withPendingContentUpdate(PendingContentUpdate pendingContentUpdate) {
        PendingOperations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pendingOperations");
        _x.pendingContentUpdate = pendingContentUpdate;
        return _x;
    }

    public PendingOperations withUnmappedField(String name, Object value) {
        PendingOperations _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PendingContentUpdate pendingContentUpdate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder pendingContentUpdate(PendingContentUpdate pendingContentUpdate) {
            this.pendingContentUpdate = pendingContentUpdate;
            this.changedFields = changedFields.add("pendingContentUpdate");
            return this;
        }

        public PendingOperations build() {
            PendingOperations _x = new PendingOperations();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.pendingOperations";
            _x.pendingContentUpdate = pendingContentUpdate;
            return _x;
        }
    }

    private PendingOperations _copy() {
        PendingOperations _x = new PendingOperations();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.pendingContentUpdate = pendingContentUpdate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PendingOperations[");
        b.append("pendingContentUpdate=");
        b.append(this.pendingContentUpdate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
