package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "fields"})
@JsonInclude(Include.NON_NULL)
public class PasswordSingleSignOnSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("fields")
    protected List<PasswordSingleSignOnField> fields;

    @JsonProperty("fields@nextLink")
    protected String fieldsNextLink;

    protected PasswordSingleSignOnSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordSingleSignOnSettings";
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<PasswordSingleSignOnField> getFields() {
        return new CollectionPage<PasswordSingleSignOnField>(contextPath, PasswordSingleSignOnField.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<PasswordSingleSignOnField> getFields(HttpRequestOptions options) {
        return new CollectionPage<PasswordSingleSignOnField>(contextPath, PasswordSingleSignOnField.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), options);
    }

    public PasswordSingleSignOnSettings withUnmappedField(String name, Object value) {
        PasswordSingleSignOnSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<PasswordSingleSignOnField> fields;
        private String fieldsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fields(List<PasswordSingleSignOnField> fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fields(PasswordSingleSignOnField... fields) {
            return fields(Arrays.asList(fields));
        }

        public Builder fieldsNextLink(String fieldsNextLink) {
            this.fieldsNextLink = fieldsNextLink;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public PasswordSingleSignOnSettings build() {
            PasswordSingleSignOnSettings _x = new PasswordSingleSignOnSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.passwordSingleSignOnSettings";
            _x.fields = fields;
            _x.fieldsNextLink = fieldsNextLink;
            return _x;
        }
    }

    private PasswordSingleSignOnSettings _copy() {
        PasswordSingleSignOnSettings _x = new PasswordSingleSignOnSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fields = fields;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordSingleSignOnSettings[");
        b.append("fields=");
        b.append(this.fields);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
