package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsDeviceUsageType;
import odata.msgraph.client.beta.enums.WindowsUserType;


/**
 * <i>“Out of box experience setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceUsageType", 
    "hideEscapeLink", 
    "hideEULA", 
    "hidePrivacySettings", 
    "skipKeyboardSelectionPage", 
    "userType"})
@JsonInclude(Include.NON_NULL)
public class OutOfBoxExperienceSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceUsageType")
    protected WindowsDeviceUsageType deviceUsageType;

    @JsonProperty("hideEscapeLink")
    protected Boolean hideEscapeLink;

    @JsonProperty("hideEULA")
    protected Boolean hideEULA;

    @JsonProperty("hidePrivacySettings")
    protected Boolean hidePrivacySettings;

    @JsonProperty("skipKeyboardSelectionPage")
    protected Boolean skipKeyboardSelectionPage;

    @JsonProperty("userType")
    protected WindowsUserType userType;

    protected OutOfBoxExperienceSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outOfBoxExperienceSettings";
    }

    /**
     * <i>“AAD join authentication type”</i>
     * 
     * @return property deviceUsageType
     */
    @Property(name="deviceUsageType")
    @JsonIgnore
    public Optional<WindowsDeviceUsageType> getDeviceUsageType() {
        return Optional.ofNullable(deviceUsageType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceUsageType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“AAD join authentication type”</i>
     * 
     * @param deviceUsageType
     *            new value of {@code deviceUsageType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceUsageType} field changed
     */
    public OutOfBoxExperienceSettings withDeviceUsageType(WindowsDeviceUsageType deviceUsageType) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.deviceUsageType = deviceUsageType;
        return _x;
    }

    /**
     * <i>“If set to true, then the user can't start over with different account, on
     * company sign-in”</i>
     * 
     * @return property hideEscapeLink
     */
    @Property(name="hideEscapeLink")
    @JsonIgnore
    public Optional<Boolean> getHideEscapeLink() {
        return Optional.ofNullable(hideEscapeLink);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hideEscapeLink}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If set to true, then the user can't start over with different account, on
     * company sign-in”</i>
     * 
     * @param hideEscapeLink
     *            new value of {@code hideEscapeLink} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hideEscapeLink} field changed
     */
    public OutOfBoxExperienceSettings withHideEscapeLink(Boolean hideEscapeLink) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.hideEscapeLink = hideEscapeLink;
        return _x;
    }

    /**
     * <i>“Show or hide EULA to user”</i>
     * 
     * @return property hideEULA
     */
    @Property(name="hideEULA")
    @JsonIgnore
    public Optional<Boolean> getHideEULA() {
        return Optional.ofNullable(hideEULA);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hideEULA} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Show or hide EULA to user”</i>
     * 
     * @param hideEULA
     *            new value of {@code hideEULA} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hideEULA} field changed
     */
    public OutOfBoxExperienceSettings withHideEULA(Boolean hideEULA) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.hideEULA = hideEULA;
        return _x;
    }

    /**
     * <i>“Show or hide privacy settings to user”</i>
     * 
     * @return property hidePrivacySettings
     */
    @Property(name="hidePrivacySettings")
    @JsonIgnore
    public Optional<Boolean> getHidePrivacySettings() {
        return Optional.ofNullable(hidePrivacySettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hidePrivacySettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Show or hide privacy settings to user”</i>
     * 
     * @param hidePrivacySettings
     *            new value of {@code hidePrivacySettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hidePrivacySettings} field changed
     */
    public OutOfBoxExperienceSettings withHidePrivacySettings(Boolean hidePrivacySettings) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.hidePrivacySettings = hidePrivacySettings;
        return _x;
    }

    /**
     * <i>“If set, then skip the keyboard selection page if Language and Region are set”</i>
     * 
     * @return property skipKeyboardSelectionPage
     */
    @Property(name="skipKeyboardSelectionPage")
    @JsonIgnore
    public Optional<Boolean> getSkipKeyboardSelectionPage() {
        return Optional.ofNullable(skipKeyboardSelectionPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * skipKeyboardSelectionPage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“If set, then skip the keyboard selection page if Language and Region are set”</i>
     * 
     * @param skipKeyboardSelectionPage
     *            new value of {@code skipKeyboardSelectionPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code skipKeyboardSelectionPage} field changed
     */
    public OutOfBoxExperienceSettings withSkipKeyboardSelectionPage(Boolean skipKeyboardSelectionPage) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.skipKeyboardSelectionPage = skipKeyboardSelectionPage;
        return _x;
    }

    /**
     * <i>“Type of user”</i>
     * 
     * @return property userType
     */
    @Property(name="userType")
    @JsonIgnore
    public Optional<WindowsUserType> getUserType() {
        return Optional.ofNullable(userType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of user”</i>
     * 
     * @param userType
     *            new value of {@code userType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userType} field changed
     */
    public OutOfBoxExperienceSettings withUserType(WindowsUserType userType) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outOfBoxExperienceSettings");
        _x.userType = userType;
        return _x;
    }

    public OutOfBoxExperienceSettings withUnmappedField(String name, Object value) {
        OutOfBoxExperienceSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsDeviceUsageType deviceUsageType;
        private Boolean hideEscapeLink;
        private Boolean hideEULA;
        private Boolean hidePrivacySettings;
        private Boolean skipKeyboardSelectionPage;
        private WindowsUserType userType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“AAD join authentication type”</i>
         * 
         * @param deviceUsageType
         *            value of {@code deviceUsageType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceUsageType(WindowsDeviceUsageType deviceUsageType) {
            this.deviceUsageType = deviceUsageType;
            this.changedFields = changedFields.add("deviceUsageType");
            return this;
        }

        /**
         * <i>“If set to true, then the user can't start over with different account, on
         * company sign-in”</i>
         * 
         * @param hideEscapeLink
         *            value of {@code hideEscapeLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hideEscapeLink(Boolean hideEscapeLink) {
            this.hideEscapeLink = hideEscapeLink;
            this.changedFields = changedFields.add("hideEscapeLink");
            return this;
        }

        /**
         * <i>“Show or hide EULA to user”</i>
         * 
         * @param hideEULA
         *            value of {@code hideEULA} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hideEULA(Boolean hideEULA) {
            this.hideEULA = hideEULA;
            this.changedFields = changedFields.add("hideEULA");
            return this;
        }

        /**
         * <i>“Show or hide privacy settings to user”</i>
         * 
         * @param hidePrivacySettings
         *            value of {@code hidePrivacySettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hidePrivacySettings(Boolean hidePrivacySettings) {
            this.hidePrivacySettings = hidePrivacySettings;
            this.changedFields = changedFields.add("hidePrivacySettings");
            return this;
        }

        /**
         * <i>“If set, then skip the keyboard selection page if Language and Region are set”</i>
         * 
         * @param skipKeyboardSelectionPage
         *            value of {@code skipKeyboardSelectionPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder skipKeyboardSelectionPage(Boolean skipKeyboardSelectionPage) {
            this.skipKeyboardSelectionPage = skipKeyboardSelectionPage;
            this.changedFields = changedFields.add("skipKeyboardSelectionPage");
            return this;
        }

        /**
         * <i>“Type of user”</i>
         * 
         * @param userType
         *            value of {@code userType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userType(WindowsUserType userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("userType");
            return this;
        }

        public OutOfBoxExperienceSettings build() {
            OutOfBoxExperienceSettings _x = new OutOfBoxExperienceSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.outOfBoxExperienceSettings";
            _x.deviceUsageType = deviceUsageType;
            _x.hideEscapeLink = hideEscapeLink;
            _x.hideEULA = hideEULA;
            _x.hidePrivacySettings = hidePrivacySettings;
            _x.skipKeyboardSelectionPage = skipKeyboardSelectionPage;
            _x.userType = userType;
            return _x;
        }
    }

    private OutOfBoxExperienceSettings _copy() {
        OutOfBoxExperienceSettings _x = new OutOfBoxExperienceSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceUsageType = deviceUsageType;
        _x.hideEscapeLink = hideEscapeLink;
        _x.hideEULA = hideEULA;
        _x.hidePrivacySettings = hidePrivacySettings;
        _x.skipKeyboardSelectionPage = skipKeyboardSelectionPage;
        _x.userType = userType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutOfBoxExperienceSettings[");
        b.append("deviceUsageType=");
        b.append(this.deviceUsageType);
        b.append(", ");
        b.append("hideEscapeLink=");
        b.append(this.hideEscapeLink);
        b.append(", ");
        b.append("hideEULA=");
        b.append(this.hideEULA);
        b.append(", ");
        b.append("hidePrivacySettings=");
        b.append(this.hidePrivacySettings);
        b.append(", ");
        b.append("skipKeyboardSelectionPage=");
        b.append(this.skipKeyboardSelectionPage);
        b.append(", ");
        b.append("userType=");
        b.append(this.userType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
