package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ScheduleEntityTheme;

@JsonPropertyOrder({
    "@odata.type", 
    "openSlotCount"})
@JsonInclude(Include.NON_NULL)
public class OpenShiftItem extends ShiftItem implements ODataType {

    @JsonProperty("openSlotCount")
    protected Integer openSlotCount;

    protected OpenShiftItem() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.openShiftItem";
    }

    @Property(name="openSlotCount")
    @JsonIgnore
    public Optional<Integer> getOpenSlotCount() {
        return Optional.ofNullable(openSlotCount);
    }

    public OpenShiftItem withOpenSlotCount(Integer openSlotCount) {
        OpenShiftItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShiftItem");
        _x.openSlotCount = openSlotCount;
        return _x;
    }

    public OpenShiftItem withUnmappedField(String name, Object value) {
        OpenShiftItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOpenShiftItem() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime endDateTime;
        private OffsetDateTime startDateTime;
        private ScheduleEntityTheme theme;
        private List<ShiftActivity> activities;
        private String activitiesNextLink;
        private String displayName;
        private String notes;
        private Integer openSlotCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder theme(ScheduleEntityTheme theme) {
            this.theme = theme;
            this.changedFields = changedFields.add("theme");
            return this;
        }

        public Builder activities(List<ShiftActivity> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(ShiftActivity... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder activitiesNextLink(String activitiesNextLink) {
            this.activitiesNextLink = activitiesNextLink;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder openSlotCount(Integer openSlotCount) {
            this.openSlotCount = openSlotCount;
            this.changedFields = changedFields.add("openSlotCount");
            return this;
        }

        public OpenShiftItem build() {
            OpenShiftItem _x = new OpenShiftItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.openShiftItem";
            _x.endDateTime = endDateTime;
            _x.startDateTime = startDateTime;
            _x.theme = theme;
            _x.activities = activities;
            _x.activitiesNextLink = activitiesNextLink;
            _x.displayName = displayName;
            _x.notes = notes;
            _x.openSlotCount = openSlotCount;
            return _x;
        }
    }

    private OpenShiftItem _copy() {
        OpenShiftItem _x = new OpenShiftItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endDateTime = endDateTime;
        _x.startDateTime = startDateTime;
        _x.theme = theme;
        _x.activities = activities;
        _x.displayName = displayName;
        _x.notes = notes;
        _x.openSlotCount = openSlotCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OpenShiftItem[");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("theme=");
        b.append(this.theme);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("openSlotCount=");
        b.append(this.openSlotCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
