package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ExternalAuthenticationType;

@JsonPropertyOrder({
    "@odata.type", 
    "alternateUrl", 
    "applicationServerTimeout", 
    "applicationType", 
    "externalAuthenticationType", 
    "externalUrl", 
    "internalUrl", 
    "isBackendCertificateValidationEnabled", 
    "isHttpOnlyCookieEnabled", 
    "isOnPremPublishingEnabled", 
    "isPersistentCookieEnabled", 
    "isSecureCookieEnabled", 
    "isTranslateHostHeaderEnabled", 
    "isTranslateLinksInBodyEnabled", 
    "singleSignOnSettings", 
    "useAlternateUrlForTranslationAndRedirect", 
    "verifiedCustomDomainCertificatesMetadata", 
    "verifiedCustomDomainKeyCredential", 
    "verifiedCustomDomainPasswordCredential"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesPublishing implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("alternateUrl")
    protected String alternateUrl;

    @JsonProperty("applicationServerTimeout")
    protected String applicationServerTimeout;

    @JsonProperty("applicationType")
    protected String applicationType;

    @JsonProperty("externalAuthenticationType")
    protected ExternalAuthenticationType externalAuthenticationType;

    @JsonProperty("externalUrl")
    protected String externalUrl;

    @JsonProperty("internalUrl")
    protected String internalUrl;

    @JsonProperty("isBackendCertificateValidationEnabled")
    protected Boolean isBackendCertificateValidationEnabled;

    @JsonProperty("isHttpOnlyCookieEnabled")
    protected Boolean isHttpOnlyCookieEnabled;

    @JsonProperty("isOnPremPublishingEnabled")
    protected Boolean isOnPremPublishingEnabled;

    @JsonProperty("isPersistentCookieEnabled")
    protected Boolean isPersistentCookieEnabled;

    @JsonProperty("isSecureCookieEnabled")
    protected Boolean isSecureCookieEnabled;

    @JsonProperty("isTranslateHostHeaderEnabled")
    protected Boolean isTranslateHostHeaderEnabled;

    @JsonProperty("isTranslateLinksInBodyEnabled")
    protected Boolean isTranslateLinksInBodyEnabled;

    @JsonProperty("singleSignOnSettings")
    protected OnPremisesPublishingSingleSignOn singleSignOnSettings;

    @JsonProperty("useAlternateUrlForTranslationAndRedirect")
    protected Boolean useAlternateUrlForTranslationAndRedirect;

    @JsonProperty("verifiedCustomDomainCertificatesMetadata")
    protected VerifiedCustomDomainCertificatesMetadata verifiedCustomDomainCertificatesMetadata;

    @JsonProperty("verifiedCustomDomainKeyCredential")
    protected KeyCredential verifiedCustomDomainKeyCredential;

    @JsonProperty("verifiedCustomDomainPasswordCredential")
    protected PasswordCredential verifiedCustomDomainPasswordCredential;

    protected OnPremisesPublishing() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesPublishing";
    }

    @Property(name="alternateUrl")
    @JsonIgnore
    public Optional<String> getAlternateUrl() {
        return Optional.ofNullable(alternateUrl);
    }

    public OnPremisesPublishing withAlternateUrl(String alternateUrl) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.alternateUrl = alternateUrl;
        return _x;
    }

    @Property(name="applicationServerTimeout")
    @JsonIgnore
    public Optional<String> getApplicationServerTimeout() {
        return Optional.ofNullable(applicationServerTimeout);
    }

    public OnPremisesPublishing withApplicationServerTimeout(String applicationServerTimeout) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.applicationServerTimeout = applicationServerTimeout;
        return _x;
    }

    @Property(name="applicationType")
    @JsonIgnore
    public Optional<String> getApplicationType() {
        return Optional.ofNullable(applicationType);
    }

    public OnPremisesPublishing withApplicationType(String applicationType) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.applicationType = applicationType;
        return _x;
    }

    @Property(name="externalAuthenticationType")
    @JsonIgnore
    public Optional<ExternalAuthenticationType> getExternalAuthenticationType() {
        return Optional.ofNullable(externalAuthenticationType);
    }

    public OnPremisesPublishing withExternalAuthenticationType(ExternalAuthenticationType externalAuthenticationType) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.externalAuthenticationType = externalAuthenticationType;
        return _x;
    }

    @Property(name="externalUrl")
    @JsonIgnore
    public Optional<String> getExternalUrl() {
        return Optional.ofNullable(externalUrl);
    }

    public OnPremisesPublishing withExternalUrl(String externalUrl) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.externalUrl = externalUrl;
        return _x;
    }

    @Property(name="internalUrl")
    @JsonIgnore
    public Optional<String> getInternalUrl() {
        return Optional.ofNullable(internalUrl);
    }

    public OnPremisesPublishing withInternalUrl(String internalUrl) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.internalUrl = internalUrl;
        return _x;
    }

    @Property(name="isBackendCertificateValidationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsBackendCertificateValidationEnabled() {
        return Optional.ofNullable(isBackendCertificateValidationEnabled);
    }

    public OnPremisesPublishing withIsBackendCertificateValidationEnabled(Boolean isBackendCertificateValidationEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isBackendCertificateValidationEnabled = isBackendCertificateValidationEnabled;
        return _x;
    }

    @Property(name="isHttpOnlyCookieEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsHttpOnlyCookieEnabled() {
        return Optional.ofNullable(isHttpOnlyCookieEnabled);
    }

    public OnPremisesPublishing withIsHttpOnlyCookieEnabled(Boolean isHttpOnlyCookieEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isHttpOnlyCookieEnabled = isHttpOnlyCookieEnabled;
        return _x;
    }

    @Property(name="isOnPremPublishingEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsOnPremPublishingEnabled() {
        return Optional.ofNullable(isOnPremPublishingEnabled);
    }

    public OnPremisesPublishing withIsOnPremPublishingEnabled(Boolean isOnPremPublishingEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isOnPremPublishingEnabled = isOnPremPublishingEnabled;
        return _x;
    }

    @Property(name="isPersistentCookieEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsPersistentCookieEnabled() {
        return Optional.ofNullable(isPersistentCookieEnabled);
    }

    public OnPremisesPublishing withIsPersistentCookieEnabled(Boolean isPersistentCookieEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isPersistentCookieEnabled = isPersistentCookieEnabled;
        return _x;
    }

    @Property(name="isSecureCookieEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsSecureCookieEnabled() {
        return Optional.ofNullable(isSecureCookieEnabled);
    }

    public OnPremisesPublishing withIsSecureCookieEnabled(Boolean isSecureCookieEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isSecureCookieEnabled = isSecureCookieEnabled;
        return _x;
    }

    @Property(name="isTranslateHostHeaderEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsTranslateHostHeaderEnabled() {
        return Optional.ofNullable(isTranslateHostHeaderEnabled);
    }

    public OnPremisesPublishing withIsTranslateHostHeaderEnabled(Boolean isTranslateHostHeaderEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isTranslateHostHeaderEnabled = isTranslateHostHeaderEnabled;
        return _x;
    }

    @Property(name="isTranslateLinksInBodyEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsTranslateLinksInBodyEnabled() {
        return Optional.ofNullable(isTranslateLinksInBodyEnabled);
    }

    public OnPremisesPublishing withIsTranslateLinksInBodyEnabled(Boolean isTranslateLinksInBodyEnabled) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.isTranslateLinksInBodyEnabled = isTranslateLinksInBodyEnabled;
        return _x;
    }

    @Property(name="singleSignOnSettings")
    @JsonIgnore
    public Optional<OnPremisesPublishingSingleSignOn> getSingleSignOnSettings() {
        return Optional.ofNullable(singleSignOnSettings);
    }

    public OnPremisesPublishing withSingleSignOnSettings(OnPremisesPublishingSingleSignOn singleSignOnSettings) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.singleSignOnSettings = singleSignOnSettings;
        return _x;
    }

    @Property(name="useAlternateUrlForTranslationAndRedirect")
    @JsonIgnore
    public Optional<Boolean> getUseAlternateUrlForTranslationAndRedirect() {
        return Optional.ofNullable(useAlternateUrlForTranslationAndRedirect);
    }

    public OnPremisesPublishing withUseAlternateUrlForTranslationAndRedirect(Boolean useAlternateUrlForTranslationAndRedirect) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.useAlternateUrlForTranslationAndRedirect = useAlternateUrlForTranslationAndRedirect;
        return _x;
    }

    @Property(name="verifiedCustomDomainCertificatesMetadata")
    @JsonIgnore
    public Optional<VerifiedCustomDomainCertificatesMetadata> getVerifiedCustomDomainCertificatesMetadata() {
        return Optional.ofNullable(verifiedCustomDomainCertificatesMetadata);
    }

    public OnPremisesPublishing withVerifiedCustomDomainCertificatesMetadata(VerifiedCustomDomainCertificatesMetadata verifiedCustomDomainCertificatesMetadata) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.verifiedCustomDomainCertificatesMetadata = verifiedCustomDomainCertificatesMetadata;
        return _x;
    }

    @Property(name="verifiedCustomDomainKeyCredential")
    @JsonIgnore
    public Optional<KeyCredential> getVerifiedCustomDomainKeyCredential() {
        return Optional.ofNullable(verifiedCustomDomainKeyCredential);
    }

    public OnPremisesPublishing withVerifiedCustomDomainKeyCredential(KeyCredential verifiedCustomDomainKeyCredential) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.verifiedCustomDomainKeyCredential = verifiedCustomDomainKeyCredential;
        return _x;
    }

    @Property(name="verifiedCustomDomainPasswordCredential")
    @JsonIgnore
    public Optional<PasswordCredential> getVerifiedCustomDomainPasswordCredential() {
        return Optional.ofNullable(verifiedCustomDomainPasswordCredential);
    }

    public OnPremisesPublishing withVerifiedCustomDomainPasswordCredential(PasswordCredential verifiedCustomDomainPasswordCredential) {
        OnPremisesPublishing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishing");
        _x.verifiedCustomDomainPasswordCredential = verifiedCustomDomainPasswordCredential;
        return _x;
    }

    public OnPremisesPublishing withUnmappedField(String name, Object value) {
        OnPremisesPublishing _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String alternateUrl;
        private String applicationServerTimeout;
        private String applicationType;
        private ExternalAuthenticationType externalAuthenticationType;
        private String externalUrl;
        private String internalUrl;
        private Boolean isBackendCertificateValidationEnabled;
        private Boolean isHttpOnlyCookieEnabled;
        private Boolean isOnPremPublishingEnabled;
        private Boolean isPersistentCookieEnabled;
        private Boolean isSecureCookieEnabled;
        private Boolean isTranslateHostHeaderEnabled;
        private Boolean isTranslateLinksInBodyEnabled;
        private OnPremisesPublishingSingleSignOn singleSignOnSettings;
        private Boolean useAlternateUrlForTranslationAndRedirect;
        private VerifiedCustomDomainCertificatesMetadata verifiedCustomDomainCertificatesMetadata;
        private KeyCredential verifiedCustomDomainKeyCredential;
        private PasswordCredential verifiedCustomDomainPasswordCredential;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder alternateUrl(String alternateUrl) {
            this.alternateUrl = alternateUrl;
            this.changedFields = changedFields.add("alternateUrl");
            return this;
        }

        public Builder applicationServerTimeout(String applicationServerTimeout) {
            this.applicationServerTimeout = applicationServerTimeout;
            this.changedFields = changedFields.add("applicationServerTimeout");
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            this.changedFields = changedFields.add("applicationType");
            return this;
        }

        public Builder externalAuthenticationType(ExternalAuthenticationType externalAuthenticationType) {
            this.externalAuthenticationType = externalAuthenticationType;
            this.changedFields = changedFields.add("externalAuthenticationType");
            return this;
        }

        public Builder externalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            this.changedFields = changedFields.add("externalUrl");
            return this;
        }

        public Builder internalUrl(String internalUrl) {
            this.internalUrl = internalUrl;
            this.changedFields = changedFields.add("internalUrl");
            return this;
        }

        public Builder isBackendCertificateValidationEnabled(Boolean isBackendCertificateValidationEnabled) {
            this.isBackendCertificateValidationEnabled = isBackendCertificateValidationEnabled;
            this.changedFields = changedFields.add("isBackendCertificateValidationEnabled");
            return this;
        }

        public Builder isHttpOnlyCookieEnabled(Boolean isHttpOnlyCookieEnabled) {
            this.isHttpOnlyCookieEnabled = isHttpOnlyCookieEnabled;
            this.changedFields = changedFields.add("isHttpOnlyCookieEnabled");
            return this;
        }

        public Builder isOnPremPublishingEnabled(Boolean isOnPremPublishingEnabled) {
            this.isOnPremPublishingEnabled = isOnPremPublishingEnabled;
            this.changedFields = changedFields.add("isOnPremPublishingEnabled");
            return this;
        }

        public Builder isPersistentCookieEnabled(Boolean isPersistentCookieEnabled) {
            this.isPersistentCookieEnabled = isPersistentCookieEnabled;
            this.changedFields = changedFields.add("isPersistentCookieEnabled");
            return this;
        }

        public Builder isSecureCookieEnabled(Boolean isSecureCookieEnabled) {
            this.isSecureCookieEnabled = isSecureCookieEnabled;
            this.changedFields = changedFields.add("isSecureCookieEnabled");
            return this;
        }

        public Builder isTranslateHostHeaderEnabled(Boolean isTranslateHostHeaderEnabled) {
            this.isTranslateHostHeaderEnabled = isTranslateHostHeaderEnabled;
            this.changedFields = changedFields.add("isTranslateHostHeaderEnabled");
            return this;
        }

        public Builder isTranslateLinksInBodyEnabled(Boolean isTranslateLinksInBodyEnabled) {
            this.isTranslateLinksInBodyEnabled = isTranslateLinksInBodyEnabled;
            this.changedFields = changedFields.add("isTranslateLinksInBodyEnabled");
            return this;
        }

        public Builder singleSignOnSettings(OnPremisesPublishingSingleSignOn singleSignOnSettings) {
            this.singleSignOnSettings = singleSignOnSettings;
            this.changedFields = changedFields.add("singleSignOnSettings");
            return this;
        }

        public Builder useAlternateUrlForTranslationAndRedirect(Boolean useAlternateUrlForTranslationAndRedirect) {
            this.useAlternateUrlForTranslationAndRedirect = useAlternateUrlForTranslationAndRedirect;
            this.changedFields = changedFields.add("useAlternateUrlForTranslationAndRedirect");
            return this;
        }

        public Builder verifiedCustomDomainCertificatesMetadata(VerifiedCustomDomainCertificatesMetadata verifiedCustomDomainCertificatesMetadata) {
            this.verifiedCustomDomainCertificatesMetadata = verifiedCustomDomainCertificatesMetadata;
            this.changedFields = changedFields.add("verifiedCustomDomainCertificatesMetadata");
            return this;
        }

        public Builder verifiedCustomDomainKeyCredential(KeyCredential verifiedCustomDomainKeyCredential) {
            this.verifiedCustomDomainKeyCredential = verifiedCustomDomainKeyCredential;
            this.changedFields = changedFields.add("verifiedCustomDomainKeyCredential");
            return this;
        }

        public Builder verifiedCustomDomainPasswordCredential(PasswordCredential verifiedCustomDomainPasswordCredential) {
            this.verifiedCustomDomainPasswordCredential = verifiedCustomDomainPasswordCredential;
            this.changedFields = changedFields.add("verifiedCustomDomainPasswordCredential");
            return this;
        }

        public OnPremisesPublishing build() {
            OnPremisesPublishing _x = new OnPremisesPublishing();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesPublishing";
            _x.alternateUrl = alternateUrl;
            _x.applicationServerTimeout = applicationServerTimeout;
            _x.applicationType = applicationType;
            _x.externalAuthenticationType = externalAuthenticationType;
            _x.externalUrl = externalUrl;
            _x.internalUrl = internalUrl;
            _x.isBackendCertificateValidationEnabled = isBackendCertificateValidationEnabled;
            _x.isHttpOnlyCookieEnabled = isHttpOnlyCookieEnabled;
            _x.isOnPremPublishingEnabled = isOnPremPublishingEnabled;
            _x.isPersistentCookieEnabled = isPersistentCookieEnabled;
            _x.isSecureCookieEnabled = isSecureCookieEnabled;
            _x.isTranslateHostHeaderEnabled = isTranslateHostHeaderEnabled;
            _x.isTranslateLinksInBodyEnabled = isTranslateLinksInBodyEnabled;
            _x.singleSignOnSettings = singleSignOnSettings;
            _x.useAlternateUrlForTranslationAndRedirect = useAlternateUrlForTranslationAndRedirect;
            _x.verifiedCustomDomainCertificatesMetadata = verifiedCustomDomainCertificatesMetadata;
            _x.verifiedCustomDomainKeyCredential = verifiedCustomDomainKeyCredential;
            _x.verifiedCustomDomainPasswordCredential = verifiedCustomDomainPasswordCredential;
            return _x;
        }
    }

    private OnPremisesPublishing _copy() {
        OnPremisesPublishing _x = new OnPremisesPublishing();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.alternateUrl = alternateUrl;
        _x.applicationServerTimeout = applicationServerTimeout;
        _x.applicationType = applicationType;
        _x.externalAuthenticationType = externalAuthenticationType;
        _x.externalUrl = externalUrl;
        _x.internalUrl = internalUrl;
        _x.isBackendCertificateValidationEnabled = isBackendCertificateValidationEnabled;
        _x.isHttpOnlyCookieEnabled = isHttpOnlyCookieEnabled;
        _x.isOnPremPublishingEnabled = isOnPremPublishingEnabled;
        _x.isPersistentCookieEnabled = isPersistentCookieEnabled;
        _x.isSecureCookieEnabled = isSecureCookieEnabled;
        _x.isTranslateHostHeaderEnabled = isTranslateHostHeaderEnabled;
        _x.isTranslateLinksInBodyEnabled = isTranslateLinksInBodyEnabled;
        _x.singleSignOnSettings = singleSignOnSettings;
        _x.useAlternateUrlForTranslationAndRedirect = useAlternateUrlForTranslationAndRedirect;
        _x.verifiedCustomDomainCertificatesMetadata = verifiedCustomDomainCertificatesMetadata;
        _x.verifiedCustomDomainKeyCredential = verifiedCustomDomainKeyCredential;
        _x.verifiedCustomDomainPasswordCredential = verifiedCustomDomainPasswordCredential;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesPublishing[");
        b.append("alternateUrl=");
        b.append(this.alternateUrl);
        b.append(", ");
        b.append("applicationServerTimeout=");
        b.append(this.applicationServerTimeout);
        b.append(", ");
        b.append("applicationType=");
        b.append(this.applicationType);
        b.append(", ");
        b.append("externalAuthenticationType=");
        b.append(this.externalAuthenticationType);
        b.append(", ");
        b.append("externalUrl=");
        b.append(this.externalUrl);
        b.append(", ");
        b.append("internalUrl=");
        b.append(this.internalUrl);
        b.append(", ");
        b.append("isBackendCertificateValidationEnabled=");
        b.append(this.isBackendCertificateValidationEnabled);
        b.append(", ");
        b.append("isHttpOnlyCookieEnabled=");
        b.append(this.isHttpOnlyCookieEnabled);
        b.append(", ");
        b.append("isOnPremPublishingEnabled=");
        b.append(this.isOnPremPublishingEnabled);
        b.append(", ");
        b.append("isPersistentCookieEnabled=");
        b.append(this.isPersistentCookieEnabled);
        b.append(", ");
        b.append("isSecureCookieEnabled=");
        b.append(this.isSecureCookieEnabled);
        b.append(", ");
        b.append("isTranslateHostHeaderEnabled=");
        b.append(this.isTranslateHostHeaderEnabled);
        b.append(", ");
        b.append("isTranslateLinksInBodyEnabled=");
        b.append(this.isTranslateLinksInBodyEnabled);
        b.append(", ");
        b.append("singleSignOnSettings=");
        b.append(this.singleSignOnSettings);
        b.append(", ");
        b.append("useAlternateUrlForTranslationAndRedirect=");
        b.append(this.useAlternateUrlForTranslationAndRedirect);
        b.append(", ");
        b.append("verifiedCustomDomainCertificatesMetadata=");
        b.append(this.verifiedCustomDomainCertificatesMetadata);
        b.append(", ");
        b.append("verifiedCustomDomainKeyCredential=");
        b.append(this.verifiedCustomDomainKeyCredential);
        b.append(", ");
        b.append("verifiedCustomDomainPasswordCredential=");
        b.append(this.verifiedCustomDomainPasswordCredential);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
