package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "occurredDateTime", 
    "propertyCausingError", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesProvisioningError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("occurredDateTime")
    protected OffsetDateTime occurredDateTime;

    @JsonProperty("propertyCausingError")
    protected String propertyCausingError;

    @JsonProperty("value")
    protected String value;

    protected OnPremisesProvisioningError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesProvisioningError";
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public OnPremisesProvisioningError withCategory(String category) {
        OnPremisesProvisioningError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesProvisioningError");
        _x.category = category;
        return _x;
    }

    @Property(name="occurredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOccurredDateTime() {
        return Optional.ofNullable(occurredDateTime);
    }

    public OnPremisesProvisioningError withOccurredDateTime(OffsetDateTime occurredDateTime) {
        OnPremisesProvisioningError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesProvisioningError");
        _x.occurredDateTime = occurredDateTime;
        return _x;
    }

    @Property(name="propertyCausingError")
    @JsonIgnore
    public Optional<String> getPropertyCausingError() {
        return Optional.ofNullable(propertyCausingError);
    }

    public OnPremisesProvisioningError withPropertyCausingError(String propertyCausingError) {
        OnPremisesProvisioningError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesProvisioningError");
        _x.propertyCausingError = propertyCausingError;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public OnPremisesProvisioningError withValue(String value) {
        OnPremisesProvisioningError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesProvisioningError");
        _x.value = value;
        return _x;
    }

    public OnPremisesProvisioningError withUnmappedField(String name, Object value) {
        OnPremisesProvisioningError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String category;
        private OffsetDateTime occurredDateTime;
        private String propertyCausingError;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder occurredDateTime(OffsetDateTime occurredDateTime) {
            this.occurredDateTime = occurredDateTime;
            this.changedFields = changedFields.add("occurredDateTime");
            return this;
        }

        public Builder propertyCausingError(String propertyCausingError) {
            this.propertyCausingError = propertyCausingError;
            this.changedFields = changedFields.add("propertyCausingError");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public OnPremisesProvisioningError build() {
            OnPremisesProvisioningError _x = new OnPremisesProvisioningError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesProvisioningError";
            _x.category = category;
            _x.occurredDateTime = occurredDateTime;
            _x.propertyCausingError = propertyCausingError;
            _x.value = value;
            return _x;
        }
    }

    private OnPremisesProvisioningError _copy() {
        OnPremisesProvisioningError _x = new OnPremisesProvisioningError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.category = category;
        _x.occurredDateTime = occurredDateTime;
        _x.propertyCausingError = propertyCausingError;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesProvisioningError[");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("occurredDateTime=");
        b.append(this.occurredDateTime);
        b.append(", ");
        b.append("propertyCausingError=");
        b.append(this.propertyCausingError);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
