package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "extensionAttribute1", 
    "extensionAttribute10", 
    "extensionAttribute11", 
    "extensionAttribute12", 
    "extensionAttribute13", 
    "extensionAttribute14", 
    "extensionAttribute15", 
    "extensionAttribute2", 
    "extensionAttribute3", 
    "extensionAttribute4", 
    "extensionAttribute5", 
    "extensionAttribute6", 
    "extensionAttribute7", 
    "extensionAttribute8", 
    "extensionAttribute9"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesExtensionAttributes implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("extensionAttribute1")
    protected String extensionAttribute1;

    @JsonProperty("extensionAttribute10")
    protected String extensionAttribute10;

    @JsonProperty("extensionAttribute11")
    protected String extensionAttribute11;

    @JsonProperty("extensionAttribute12")
    protected String extensionAttribute12;

    @JsonProperty("extensionAttribute13")
    protected String extensionAttribute13;

    @JsonProperty("extensionAttribute14")
    protected String extensionAttribute14;

    @JsonProperty("extensionAttribute15")
    protected String extensionAttribute15;

    @JsonProperty("extensionAttribute2")
    protected String extensionAttribute2;

    @JsonProperty("extensionAttribute3")
    protected String extensionAttribute3;

    @JsonProperty("extensionAttribute4")
    protected String extensionAttribute4;

    @JsonProperty("extensionAttribute5")
    protected String extensionAttribute5;

    @JsonProperty("extensionAttribute6")
    protected String extensionAttribute6;

    @JsonProperty("extensionAttribute7")
    protected String extensionAttribute7;

    @JsonProperty("extensionAttribute8")
    protected String extensionAttribute8;

    @JsonProperty("extensionAttribute9")
    protected String extensionAttribute9;

    protected OnPremisesExtensionAttributes() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesExtensionAttributes";
    }

    @Property(name="extensionAttribute1")
    @JsonIgnore
    public Optional<String> getExtensionAttribute1() {
        return Optional.ofNullable(extensionAttribute1);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute1(String extensionAttribute1) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute1 = extensionAttribute1;
        return _x;
    }

    @Property(name="extensionAttribute10")
    @JsonIgnore
    public Optional<String> getExtensionAttribute10() {
        return Optional.ofNullable(extensionAttribute10);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute10(String extensionAttribute10) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute10 = extensionAttribute10;
        return _x;
    }

    @Property(name="extensionAttribute11")
    @JsonIgnore
    public Optional<String> getExtensionAttribute11() {
        return Optional.ofNullable(extensionAttribute11);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute11(String extensionAttribute11) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute11 = extensionAttribute11;
        return _x;
    }

    @Property(name="extensionAttribute12")
    @JsonIgnore
    public Optional<String> getExtensionAttribute12() {
        return Optional.ofNullable(extensionAttribute12);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute12(String extensionAttribute12) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute12 = extensionAttribute12;
        return _x;
    }

    @Property(name="extensionAttribute13")
    @JsonIgnore
    public Optional<String> getExtensionAttribute13() {
        return Optional.ofNullable(extensionAttribute13);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute13(String extensionAttribute13) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute13 = extensionAttribute13;
        return _x;
    }

    @Property(name="extensionAttribute14")
    @JsonIgnore
    public Optional<String> getExtensionAttribute14() {
        return Optional.ofNullable(extensionAttribute14);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute14(String extensionAttribute14) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute14 = extensionAttribute14;
        return _x;
    }

    @Property(name="extensionAttribute15")
    @JsonIgnore
    public Optional<String> getExtensionAttribute15() {
        return Optional.ofNullable(extensionAttribute15);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute15(String extensionAttribute15) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute15 = extensionAttribute15;
        return _x;
    }

    @Property(name="extensionAttribute2")
    @JsonIgnore
    public Optional<String> getExtensionAttribute2() {
        return Optional.ofNullable(extensionAttribute2);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute2(String extensionAttribute2) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute2 = extensionAttribute2;
        return _x;
    }

    @Property(name="extensionAttribute3")
    @JsonIgnore
    public Optional<String> getExtensionAttribute3() {
        return Optional.ofNullable(extensionAttribute3);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute3(String extensionAttribute3) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute3 = extensionAttribute3;
        return _x;
    }

    @Property(name="extensionAttribute4")
    @JsonIgnore
    public Optional<String> getExtensionAttribute4() {
        return Optional.ofNullable(extensionAttribute4);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute4(String extensionAttribute4) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute4 = extensionAttribute4;
        return _x;
    }

    @Property(name="extensionAttribute5")
    @JsonIgnore
    public Optional<String> getExtensionAttribute5() {
        return Optional.ofNullable(extensionAttribute5);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute5(String extensionAttribute5) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute5 = extensionAttribute5;
        return _x;
    }

    @Property(name="extensionAttribute6")
    @JsonIgnore
    public Optional<String> getExtensionAttribute6() {
        return Optional.ofNullable(extensionAttribute6);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute6(String extensionAttribute6) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute6 = extensionAttribute6;
        return _x;
    }

    @Property(name="extensionAttribute7")
    @JsonIgnore
    public Optional<String> getExtensionAttribute7() {
        return Optional.ofNullable(extensionAttribute7);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute7(String extensionAttribute7) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute7 = extensionAttribute7;
        return _x;
    }

    @Property(name="extensionAttribute8")
    @JsonIgnore
    public Optional<String> getExtensionAttribute8() {
        return Optional.ofNullable(extensionAttribute8);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute8(String extensionAttribute8) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute8 = extensionAttribute8;
        return _x;
    }

    @Property(name="extensionAttribute9")
    @JsonIgnore
    public Optional<String> getExtensionAttribute9() {
        return Optional.ofNullable(extensionAttribute9);
    }

    public OnPremisesExtensionAttributes withExtensionAttribute9(String extensionAttribute9) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesExtensionAttributes");
        _x.extensionAttribute9 = extensionAttribute9;
        return _x;
    }

    public OnPremisesExtensionAttributes withUnmappedField(String name, Object value) {
        OnPremisesExtensionAttributes _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String extensionAttribute1;
        private String extensionAttribute10;
        private String extensionAttribute11;
        private String extensionAttribute12;
        private String extensionAttribute13;
        private String extensionAttribute14;
        private String extensionAttribute15;
        private String extensionAttribute2;
        private String extensionAttribute3;
        private String extensionAttribute4;
        private String extensionAttribute5;
        private String extensionAttribute6;
        private String extensionAttribute7;
        private String extensionAttribute8;
        private String extensionAttribute9;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder extensionAttribute1(String extensionAttribute1) {
            this.extensionAttribute1 = extensionAttribute1;
            this.changedFields = changedFields.add("extensionAttribute1");
            return this;
        }

        public Builder extensionAttribute10(String extensionAttribute10) {
            this.extensionAttribute10 = extensionAttribute10;
            this.changedFields = changedFields.add("extensionAttribute10");
            return this;
        }

        public Builder extensionAttribute11(String extensionAttribute11) {
            this.extensionAttribute11 = extensionAttribute11;
            this.changedFields = changedFields.add("extensionAttribute11");
            return this;
        }

        public Builder extensionAttribute12(String extensionAttribute12) {
            this.extensionAttribute12 = extensionAttribute12;
            this.changedFields = changedFields.add("extensionAttribute12");
            return this;
        }

        public Builder extensionAttribute13(String extensionAttribute13) {
            this.extensionAttribute13 = extensionAttribute13;
            this.changedFields = changedFields.add("extensionAttribute13");
            return this;
        }

        public Builder extensionAttribute14(String extensionAttribute14) {
            this.extensionAttribute14 = extensionAttribute14;
            this.changedFields = changedFields.add("extensionAttribute14");
            return this;
        }

        public Builder extensionAttribute15(String extensionAttribute15) {
            this.extensionAttribute15 = extensionAttribute15;
            this.changedFields = changedFields.add("extensionAttribute15");
            return this;
        }

        public Builder extensionAttribute2(String extensionAttribute2) {
            this.extensionAttribute2 = extensionAttribute2;
            this.changedFields = changedFields.add("extensionAttribute2");
            return this;
        }

        public Builder extensionAttribute3(String extensionAttribute3) {
            this.extensionAttribute3 = extensionAttribute3;
            this.changedFields = changedFields.add("extensionAttribute3");
            return this;
        }

        public Builder extensionAttribute4(String extensionAttribute4) {
            this.extensionAttribute4 = extensionAttribute4;
            this.changedFields = changedFields.add("extensionAttribute4");
            return this;
        }

        public Builder extensionAttribute5(String extensionAttribute5) {
            this.extensionAttribute5 = extensionAttribute5;
            this.changedFields = changedFields.add("extensionAttribute5");
            return this;
        }

        public Builder extensionAttribute6(String extensionAttribute6) {
            this.extensionAttribute6 = extensionAttribute6;
            this.changedFields = changedFields.add("extensionAttribute6");
            return this;
        }

        public Builder extensionAttribute7(String extensionAttribute7) {
            this.extensionAttribute7 = extensionAttribute7;
            this.changedFields = changedFields.add("extensionAttribute7");
            return this;
        }

        public Builder extensionAttribute8(String extensionAttribute8) {
            this.extensionAttribute8 = extensionAttribute8;
            this.changedFields = changedFields.add("extensionAttribute8");
            return this;
        }

        public Builder extensionAttribute9(String extensionAttribute9) {
            this.extensionAttribute9 = extensionAttribute9;
            this.changedFields = changedFields.add("extensionAttribute9");
            return this;
        }

        public OnPremisesExtensionAttributes build() {
            OnPremisesExtensionAttributes _x = new OnPremisesExtensionAttributes();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesExtensionAttributes";
            _x.extensionAttribute1 = extensionAttribute1;
            _x.extensionAttribute10 = extensionAttribute10;
            _x.extensionAttribute11 = extensionAttribute11;
            _x.extensionAttribute12 = extensionAttribute12;
            _x.extensionAttribute13 = extensionAttribute13;
            _x.extensionAttribute14 = extensionAttribute14;
            _x.extensionAttribute15 = extensionAttribute15;
            _x.extensionAttribute2 = extensionAttribute2;
            _x.extensionAttribute3 = extensionAttribute3;
            _x.extensionAttribute4 = extensionAttribute4;
            _x.extensionAttribute5 = extensionAttribute5;
            _x.extensionAttribute6 = extensionAttribute6;
            _x.extensionAttribute7 = extensionAttribute7;
            _x.extensionAttribute8 = extensionAttribute8;
            _x.extensionAttribute9 = extensionAttribute9;
            return _x;
        }
    }

    private OnPremisesExtensionAttributes _copy() {
        OnPremisesExtensionAttributes _x = new OnPremisesExtensionAttributes();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.extensionAttribute1 = extensionAttribute1;
        _x.extensionAttribute10 = extensionAttribute10;
        _x.extensionAttribute11 = extensionAttribute11;
        _x.extensionAttribute12 = extensionAttribute12;
        _x.extensionAttribute13 = extensionAttribute13;
        _x.extensionAttribute14 = extensionAttribute14;
        _x.extensionAttribute15 = extensionAttribute15;
        _x.extensionAttribute2 = extensionAttribute2;
        _x.extensionAttribute3 = extensionAttribute3;
        _x.extensionAttribute4 = extensionAttribute4;
        _x.extensionAttribute5 = extensionAttribute5;
        _x.extensionAttribute6 = extensionAttribute6;
        _x.extensionAttribute7 = extensionAttribute7;
        _x.extensionAttribute8 = extensionAttribute8;
        _x.extensionAttribute9 = extensionAttribute9;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesExtensionAttributes[");
        b.append("extensionAttribute1=");
        b.append(this.extensionAttribute1);
        b.append(", ");
        b.append("extensionAttribute10=");
        b.append(this.extensionAttribute10);
        b.append(", ");
        b.append("extensionAttribute11=");
        b.append(this.extensionAttribute11);
        b.append(", ");
        b.append("extensionAttribute12=");
        b.append(this.extensionAttribute12);
        b.append(", ");
        b.append("extensionAttribute13=");
        b.append(this.extensionAttribute13);
        b.append(", ");
        b.append("extensionAttribute14=");
        b.append(this.extensionAttribute14);
        b.append(", ");
        b.append("extensionAttribute15=");
        b.append(this.extensionAttribute15);
        b.append(", ");
        b.append("extensionAttribute2=");
        b.append(this.extensionAttribute2);
        b.append(", ");
        b.append("extensionAttribute3=");
        b.append(this.extensionAttribute3);
        b.append(", ");
        b.append("extensionAttribute4=");
        b.append(this.extensionAttribute4);
        b.append(", ");
        b.append("extensionAttribute5=");
        b.append(this.extensionAttribute5);
        b.append(", ");
        b.append("extensionAttribute6=");
        b.append(this.extensionAttribute6);
        b.append(", ");
        b.append("extensionAttribute7=");
        b.append(this.extensionAttribute7);
        b.append(", ");
        b.append("extensionAttribute8=");
        b.append(this.extensionAttribute8);
        b.append(", ");
        b.append("extensionAttribute9=");
        b.append(this.extensionAttribute9);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
